/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.folsom.GetResult;
import com.spotify.folsom.Transcoder;
import com.spotify.folsom.client.Utils;
import java.util.List;

public class TransformerUtil<T> {
    private final Function<GetResult<T>, T> getResultToValue = new ResultUnwrapper();
    private final ListResultUnwrapper<T> listResultUnwrapper = new ListResultUnwrapper<T>(this.getResultToValue);
    private final ResultDecoder<T> resultDecoder;
    private final ListResultDecoder<T> listResultDecoder;

    public TransformerUtil(Transcoder<T> transcoder) {
        this.resultDecoder = new ResultDecoder<T>(transcoder);
        this.listResultDecoder = new ListResultDecoder<T>(this.resultDecoder);
    }

    public ListenableFuture<T> unwrap(ListenableFuture<GetResult<T>> future) {
        return Utils.transform(future, this.getResultToValue);
    }

    public ListenableFuture<GetResult<T>> decode(ListenableFuture<GetResult<byte[]>> future) {
        return Utils.transform(future, this.resultDecoder);
    }

    public ListenableFuture<List<T>> unwrapList(ListenableFuture<List<GetResult<T>>> future) {
        return Utils.transform(future, this.listResultUnwrapper);
    }

    public ListenableFuture<List<GetResult<T>>> decodeList(ListenableFuture<List<GetResult<byte[]>>> future) {
        return Utils.transform(future, this.listResultDecoder);
    }

    private static class ListResultDecoder<T>
    implements Function<List<GetResult<byte[]>>, List<GetResult<T>>> {
        private final ResultDecoder<T> resultDecoder;

        public ListResultDecoder(ResultDecoder<T> resultDecoder) {
            this.resultDecoder = resultDecoder;
        }

        public List<GetResult<T>> apply(List<GetResult<byte[]>> input) {
            return Lists.transform(input, this.resultDecoder);
        }
    }

    private static class ResultDecoder<T>
    implements Function<GetResult<byte[]>, GetResult<T>> {
        private final Transcoder<T> transcoder;

        public ResultDecoder(Transcoder<T> transcoder) {
            this.transcoder = transcoder;
        }

        public GetResult<T> apply(GetResult<byte[]> input) {
            if (input == null) {
                return null;
            }
            return GetResult.success(this.transcoder.decode(input.getValue()), input.getCas());
        }
    }

    private static class ListResultUnwrapper<T>
    implements Function<List<GetResult<T>>, List<T>> {
        private final Function<GetResult<T>, T> resultUnwrapper;

        public ListResultUnwrapper(Function<GetResult<T>, T> resultUnwrapper) {
            this.resultUnwrapper = resultUnwrapper;
        }

        public List<T> apply(List<GetResult<T>> input) {
            return Lists.transform(input, this.resultUnwrapper);
        }
    }

    private static class ResultUnwrapper<T>
    implements Function<GetResult<T>, T> {
        private ResultUnwrapper() {
        }

        public T apply(GetResult<T> input) {
            if (input == null) {
                return null;
            }
            return input.getValue();
        }
    }
}

