/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.folsom.GetResult;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.Metrics;
import com.spotify.folsom.client.Utils;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class YammerMetrics
implements Metrics {
    public static final String GROUP = "com.spotify.folsom";
    private final Timer gets;
    private final Meter getHits;
    private final Meter getMisses;
    private final Meter getSuccesses;
    private final Meter getFailures;
    private final Timer multigets;
    private final Meter multigetSuccesses;
    private final Meter multigetFailures;
    private final Timer sets;
    private final Meter setSuccesses;
    private final Meter setFailures;
    private final Timer deletes;
    private final Meter deleteSuccesses;
    private final Meter deleteFailures;
    private final Timer incrDecrs;
    private final Meter incrDecrSuccesses;
    private final Meter incrDecrFailures;
    private final Timer touches;
    private final Meter touchSuccesses;
    private final Meter touchFailures;

    public YammerMetrics(MetricsRegistry registry) {
        this.gets = registry.newTimer(this.name("get", "requests"), TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.getSuccesses = registry.newMeter(this.name("get", "successes"), "Successes", TimeUnit.SECONDS);
        this.getHits = registry.newMeter(this.name("get", "hits"), "Hits", TimeUnit.SECONDS);
        this.getMisses = registry.newMeter(this.name("get", "misses"), "Misses", TimeUnit.SECONDS);
        this.getFailures = registry.newMeter(this.name("get", "failures"), "Failures", TimeUnit.SECONDS);
        this.multigets = registry.newTimer(this.name("multiget", "requests"), TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.multigetSuccesses = registry.newMeter(this.name("multiget", "successes"), "Successes", TimeUnit.SECONDS);
        this.multigetFailures = registry.newMeter(this.name("multiget", "failures"), "Failures", TimeUnit.SECONDS);
        this.sets = registry.newTimer(this.name("set", "requests"), TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.setSuccesses = registry.newMeter(this.name("set", "successes"), "Successes", TimeUnit.SECONDS);
        this.setFailures = registry.newMeter(this.name("set", "failures"), "Failures", TimeUnit.SECONDS);
        this.deletes = registry.newTimer(this.name("delete", "requests"), TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.deleteSuccesses = registry.newMeter(this.name("delete", "successes"), "Successes", TimeUnit.SECONDS);
        this.deleteFailures = registry.newMeter(this.name("delete", "failures"), "Failures", TimeUnit.SECONDS);
        this.incrDecrs = registry.newTimer(this.name("incrdecr", "requests"), TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.incrDecrSuccesses = registry.newMeter(this.name("incrdecr", "successes"), "Successes", TimeUnit.SECONDS);
        this.incrDecrFailures = registry.newMeter(this.name("incrdecr", "failures"), "Failures", TimeUnit.SECONDS);
        this.touches = registry.newTimer(this.name("touch", "requests"), TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.touchSuccesses = registry.newMeter(this.name("touch", "successes"), "Successes", TimeUnit.SECONDS);
        this.touchFailures = registry.newMeter(this.name("touch", "failures"), "Failures", TimeUnit.SECONDS);
    }

    private MetricName name(String type, String name) {
        return new MetricName(GROUP, type, name);
    }

    @Override
    public void measureGetFuture(ListenableFuture<GetResult<byte[]>> future) {
        final TimerContext ctx = this.gets.time();
        FutureCallback<GetResult<byte[]>> metricsCallback = new FutureCallback<GetResult<byte[]>>(){

            public void onSuccess(GetResult<byte[]> result) {
                YammerMetrics.this.getSuccesses.mark();
                if (result != null) {
                    YammerMetrics.this.getHits.mark();
                } else {
                    YammerMetrics.this.getMisses.mark();
                }
                ctx.stop();
            }

            public void onFailure(Throwable t) {
                YammerMetrics.this.getFailures.mark();
                ctx.stop();
            }
        };
        Futures.addCallback(future, (FutureCallback)metricsCallback, (Executor)Utils.SAME_THREAD_EXECUTOR);
    }

    @Override
    public void measureMultigetFuture(ListenableFuture<List<GetResult<byte[]>>> future) {
        final TimerContext ctx = this.multigets.time();
        FutureCallback<List<GetResult<byte[]>>> metricsCallback = new FutureCallback<List<GetResult<byte[]>>>(){

            public void onSuccess(List<GetResult<byte[]>> result) {
                YammerMetrics.this.multigetSuccesses.mark();
                int hits = 0;
                int total = result.size();
                for (int i = 0; i < total; ++i) {
                    if (result.get(i) == null) continue;
                    ++hits;
                }
                YammerMetrics.this.getHits.mark((long)hits);
                YammerMetrics.this.getMisses.mark((long)(total - hits));
                ctx.stop();
            }

            public void onFailure(Throwable t) {
                YammerMetrics.this.multigetFailures.mark();
                ctx.stop();
            }
        };
        Futures.addCallback(future, (FutureCallback)metricsCallback, (Executor)Utils.SAME_THREAD_EXECUTOR);
    }

    @Override
    public void measureDeleteFuture(ListenableFuture<MemcacheStatus> future) {
        final TimerContext ctx = this.deletes.time();
        FutureCallback<MemcacheStatus> metricsCallback = new FutureCallback<MemcacheStatus>(){

            public void onSuccess(MemcacheStatus result) {
                YammerMetrics.this.deleteSuccesses.mark();
                ctx.stop();
            }

            public void onFailure(Throwable t) {
                YammerMetrics.this.deleteFailures.mark();
                ctx.stop();
            }
        };
        Futures.addCallback(future, (FutureCallback)metricsCallback, (Executor)Utils.SAME_THREAD_EXECUTOR);
    }

    @Override
    public void measureSetFuture(ListenableFuture<MemcacheStatus> future) {
        final TimerContext ctx = this.sets.time();
        FutureCallback<MemcacheStatus> metricsCallback = new FutureCallback<MemcacheStatus>(){

            public void onSuccess(MemcacheStatus result) {
                YammerMetrics.this.setSuccesses.mark();
                ctx.stop();
            }

            public void onFailure(Throwable t) {
                YammerMetrics.this.setFailures.mark();
                ctx.stop();
            }
        };
        Futures.addCallback(future, (FutureCallback)metricsCallback, (Executor)Utils.SAME_THREAD_EXECUTOR);
    }

    @Override
    public void measureIncrDecrFuture(ListenableFuture<Long> future) {
        final TimerContext ctx = this.incrDecrs.time();
        FutureCallback<Long> metricsCallback = new FutureCallback<Long>(){

            public void onSuccess(Long result) {
                YammerMetrics.this.incrDecrSuccesses.mark();
                ctx.stop();
            }

            public void onFailure(Throwable t) {
                YammerMetrics.this.incrDecrFailures.mark();
                ctx.stop();
            }
        };
        Futures.addCallback(future, (FutureCallback)metricsCallback, (Executor)Utils.SAME_THREAD_EXECUTOR);
    }

    @Override
    public void measureTouchFuture(ListenableFuture<MemcacheStatus> future) {
        final TimerContext ctx = this.touches.time();
        FutureCallback<MemcacheStatus> metricsCallback = new FutureCallback<MemcacheStatus>(){

            public void onSuccess(MemcacheStatus result) {
                YammerMetrics.this.touchSuccesses.mark();
                ctx.stop();
            }

            public void onFailure(Throwable t) {
                YammerMetrics.this.touchFailures.mark();
                ctx.stop();
            }
        };
        Futures.addCallback(future, (FutureCallback)metricsCallback, (Executor)Utils.SAME_THREAD_EXECUTOR);
    }

    public Timer getGets() {
        return this.gets;
    }

    public Meter getGetHits() {
        return this.getHits;
    }

    public Meter getGetMisses() {
        return this.getMisses;
    }

    public Meter getGetSuccesses() {
        return this.getSuccesses;
    }

    public Meter getGetFailures() {
        return this.getFailures;
    }

    public Timer getMultigets() {
        return this.multigets;
    }

    public Meter getMultigetSuccesses() {
        return this.multigetSuccesses;
    }

    public Meter getMultigetFailures() {
        return this.multigetFailures;
    }

    public Timer getSets() {
        return this.sets;
    }

    public Meter getSetSuccesses() {
        return this.setSuccesses;
    }

    public Meter getSetFailures() {
        return this.setFailures;
    }

    public Timer getDeletes() {
        return this.deletes;
    }

    public Meter getDeleteSuccesses() {
        return this.deleteSuccesses;
    }

    public Meter getDeleteFailures() {
        return this.deleteFailures;
    }

    public Timer getIncrDecrs() {
        return this.incrDecrs;
    }

    public Meter getIncrDecrSuccesses() {
        return this.incrDecrSuccesses;
    }

    public Meter getIncrDecrFailures() {
        return this.incrDecrFailures;
    }

    public Timer getTouches() {
        return this.touches;
    }

    public Meter getTouchSuccesses() {
        return this.touchSuccesses;
    }

    public Meter getTouchFailures() {
        return this.touchFailures;
    }
}

