/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.google.common.base.Charsets;
import com.spotify.folsom.GetResult;
import com.spotify.folsom.client.ascii.AsciiRequest;
import com.spotify.folsom.client.ascii.AsciiResponse;
import com.spotify.folsom.client.ascii.ValueAsciiResponse;
import com.spotify.folsom.client.ascii.ValueResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

public class GetRequest
extends AsciiRequest<GetResult<byte[]>>
implements com.spotify.folsom.client.GetRequest {
    private static final byte[] GET = "get ".getBytes(Charsets.US_ASCII);
    private static final byte[] CAS_GET = "gets ".getBytes(Charsets.US_ASCII);
    private final byte[] cmd;

    public GetRequest(String key, Charset charset, boolean withCas) {
        super(key, charset);
        this.cmd = withCas ? CAS_GET : GET;
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        dst.put(this.cmd);
        dst.put(this.key);
        dst.put(NEWLINE_BYTES);
        return GetRequest.toBuffer(alloc, dst);
    }

    @Override
    public void handle(AsciiResponse response) throws IOException {
        if (!(response instanceof ValueAsciiResponse)) {
            throw new IOException("Unexpected response type: " + (Object)((Object)response.type));
        }
        List<ValueResponse> values = ((ValueAsciiResponse)response).values;
        if (values.isEmpty()) {
            this.succeed(null);
            return;
        }
        if (values.size() > 1) {
            throw new IOException("Too many responses, expected 1 but got " + values.size());
        }
        ValueResponse valueResponse = values.get(0);
        if (!Arrays.equals(valueResponse.key, this.key)) {
            String message = "Expected key " + this.decodeKey(this.key) + " but got " + this.decodeKey(valueResponse.key);
            throw new IOException(message);
        }
        this.succeed(GetResult.success(valueResponse.value, valueResponse.cas));
    }

    private String decodeKey(byte[] key1) {
        return new String(key1, Charsets.US_ASCII);
    }
}

