/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.google.common.base.Charsets;
import com.spotify.folsom.client.ascii.AsciiRequest;
import com.spotify.folsom.client.ascii.AsciiResponse;
import com.spotify.folsom.client.ascii.NumericAsciiResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class IncrRequest
extends AsciiRequest<Long> {
    private static final byte[] INCR_CMD = "incr ".getBytes(Charsets.US_ASCII);
    private static final byte[] DECR_CMD = "decr ".getBytes(Charsets.US_ASCII);
    private final byte[] operation;
    private final long by;

    private IncrRequest(byte[] operation, String key, long by, Charset charset) {
        super(key, charset);
        this.operation = operation;
        this.by = by;
    }

    public static IncrRequest createIncr(String key, Charset charset, long value) {
        return new IncrRequest(INCR_CMD, key, value, charset);
    }

    public static IncrRequest createDecr(String key, Charset charset, long value) {
        return new IncrRequest(DECR_CMD, key, value, charset);
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        dst.put(this.operation);
        dst.put(this.key);
        dst.put((byte)32);
        dst.put(String.valueOf(this.by).getBytes());
        dst.put(NEWLINE_BYTES);
        return IncrRequest.toBuffer(alloc, dst);
    }

    @Override
    public void handle(AsciiResponse response) throws IOException {
        if (response instanceof NumericAsciiResponse) {
            this.succeed(((NumericAsciiResponse)response).numericValue);
        } else if (response.type == AsciiResponse.Type.NOT_FOUND) {
            this.succeed(null);
        } else {
            throw new IOException("Unexpected response type: " + (Object)((Object)response.type));
        }
    }

    public long getBy() {
        return this.by;
    }

    public long multiplier() {
        return this.operation == INCR_CMD ? 1L : -1L;
    }
}

