/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.google.common.base.Charsets;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.ascii.AsciiRequest;
import com.spotify.folsom.client.ascii.AsciiResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.EnumMap;

public class SetRequest
extends AsciiRequest<MemcacheStatus>
implements com.spotify.folsom.client.SetRequest {
    private static final EnumMap<Operation, byte[]> CMD = new EnumMap(Operation.class);
    private static final byte[] FLAGS;
    private final Operation operation;
    private final byte[] value;
    private final int ttl;
    private final long cas;

    private SetRequest(Operation operation, String key, Charset charset, byte[] value, int ttl, long cas) {
        super(key, charset);
        this.operation = operation;
        this.value = value;
        this.ttl = ttl;
        this.cas = cas;
    }

    public static SetRequest casSet(String key, Charset charset, byte[] value, int ttl, long cas) {
        return new SetRequest(Operation.CAS, key, charset, value, ttl, cas);
    }

    public static SetRequest create(Operation operation, String key, Charset charset, byte[] value, int ttl) {
        if (operation == null || operation == Operation.CAS) {
            throw new IllegalArgumentException("Invalid operation: " + (Object)((Object)operation));
        }
        return new SetRequest(operation, key, charset, value, ttl, 0L);
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        dst.put(CMD.get((Object)this.operation));
        dst.put(this.key);
        dst.put(FLAGS);
        dst.put(String.valueOf(this.ttl).getBytes());
        dst.put((byte)32);
        dst.put(String.valueOf(this.value.length).getBytes());
        if (this.operation == Operation.CAS) {
            dst.put((byte)32);
            dst.put(String.valueOf(this.cas).getBytes());
        }
        dst.put(NEWLINE_BYTES);
        if (dst.remaining() >= this.value.length + NEWLINE_BYTES.length) {
            dst.put(this.value);
            dst.put(NEWLINE_BYTES);
            return SetRequest.toBuffer(alloc, dst);
        }
        return SetRequest.toBufferWithValueAndNewLine(alloc, dst, this.value);
    }

    private static ByteBuf toBufferWithValueAndNewLine(ByteBufAllocator alloc, ByteBuffer dst, byte[] value) {
        ByteBuf buffer = SetRequest.toBuffer(alloc, dst, value.length + NEWLINE_BYTES.length);
        buffer.writeBytes(value);
        buffer.writeBytes(NEWLINE_BYTES);
        return buffer;
    }

    @Override
    public void handle(AsciiResponse response) throws IOException {
        switch (response.type) {
            case STORED: {
                this.succeed(MemcacheStatus.OK);
                return;
            }
            case NOT_STORED: {
                this.succeed(MemcacheStatus.ITEM_NOT_STORED);
                return;
            }
            case EXISTS: {
                this.succeed(MemcacheStatus.KEY_EXISTS);
                return;
            }
            case NOT_FOUND: {
                if (this.operation == Operation.APPEND || this.operation == Operation.PREPEND) {
                    this.succeed(MemcacheStatus.ITEM_NOT_STORED);
                } else {
                    this.succeed(MemcacheStatus.KEY_NOT_FOUND);
                }
                return;
            }
        }
        throw new IOException("Unexpected line: " + (Object)((Object)response.type));
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    static {
        CMD.put(Operation.SET, "set ".getBytes(Charsets.US_ASCII));
        CMD.put(Operation.ADD, "add ".getBytes(Charsets.US_ASCII));
        CMD.put(Operation.REPLACE, "replace ".getBytes(Charsets.US_ASCII));
        CMD.put(Operation.APPEND, "append ".getBytes(Charsets.US_ASCII));
        CMD.put(Operation.PREPEND, "prepend ".getBytes(Charsets.US_ASCII));
        CMD.put(Operation.CAS, "cas ".getBytes(Charsets.US_ASCII));
        FLAGS = " 0 ".getBytes(Charsets.US_ASCII);
    }

    public static enum Operation {
        SET,
        ADD,
        REPLACE,
        APPEND,
        PREPEND,
        CAS;

    }
}

