/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class BinaryRequest<V>
extends Request<V> {
    protected static final int HEADER_SIZE = 24;
    protected static final byte MAGIC_NUMBER = -128;

    protected BinaryRequest(String key, Charset charset, int opaque) {
        super(key, charset, opaque);
    }

    protected BinaryRequest(byte[] key, int opaque) {
        super(key, opaque);
    }

    public void writeHeader(ByteBuffer dst, byte opCode, int extraLength, int valueLength, long cas, int opaque) {
        int keyLength = this.key.length;
        dst.put((byte)-128);
        dst.put(opCode);
        dst.putShort((short)keyLength);
        dst.put((byte)extraLength);
        dst.put((byte)0);
        dst.put((byte)0);
        dst.put((byte)0);
        dst.putInt(extraLength + keyLength + valueLength);
        dst.putInt(opaque);
        dst.putLong(cas);
    }

    protected ResponsePacket handleSingleReply(BinaryResponse replies) throws IOException {
        if (replies.size() != 1) {
            throw new IOException("got " + replies.size() + " replies but expected 1 for " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        ResponsePacket reply = (ResponsePacket)replies.get(0);
        if (reply.opaque != this.opaque) {
            throw new IOException("messages out of order for " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        return reply;
    }

    @Override
    public void handle(Object response) throws IOException {
        this.handle((BinaryResponse)response);
    }

    protected abstract void handle(BinaryResponse var1) throws IOException;
}

