/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.google.common.primitives.Longs;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.binary.BinaryRequest;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class IncrRequest
extends BinaryRequest<Long> {
    private final byte opcode;
    private final long by;
    private final long initial;
    private final int ttl;

    public IncrRequest(String key, Charset charset, byte opcode, long by, long initial, int ttl, int opaque) {
        super(key, charset, opaque);
        this.opcode = opcode;
        this.by = by;
        this.initial = initial;
        this.ttl = ttl;
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        int expiration = Utils.ttlToExpiration(this.ttl);
        int extraLength = 20;
        this.writeHeader(dst, this.opcode, 20, 0, 0L, this.opaque);
        dst.putLong(this.by);
        dst.putLong(this.initial);
        dst.putInt(expiration);
        dst.put(this.key);
        return IncrRequest.toBuffer(alloc, dst);
    }

    @Override
    public void handle(BinaryResponse replies) throws IOException {
        ResponsePacket reply = this.handleSingleReply(replies);
        if (reply.status == MemcacheStatus.OK) {
            this.succeed(Longs.fromByteArray((byte[])reply.value));
        } else if (reply.status == MemcacheStatus.KEY_NOT_FOUND) {
            this.succeed(null);
        } else {
            throw new IOException("Unexpected response: " + (Object)((Object)reply.status));
        }
    }
}

