/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.binary.BinaryRequest;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class TouchRequest
extends BinaryRequest<MemcacheStatus> {
    private final int ttl;

    public TouchRequest(String key, Charset charset, int ttl, int opaque) {
        super(key, charset, opaque);
        this.ttl = ttl;
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        int expiration = Utils.ttlToExpiration(this.ttl);
        int extrasLength = 4;
        this.writeHeader(dst, (byte)28, 4, 0, 0L, this.opaque);
        dst.putInt(expiration);
        dst.put(this.key);
        return TouchRequest.toBuffer(alloc, dst);
    }

    @Override
    public void handle(BinaryResponse replies) throws IOException {
        ResponsePacket reply = this.handleSingleReply(replies);
        this.succeed(reply.status);
    }
}

