/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.spotify.folsom.AbstractRawMemcacheClient;
import com.spotify.folsom.MemcacheClosedException;
import com.spotify.folsom.MemcacheOverloadedException;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.Metrics;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.client.BatchFlusher;
import com.spotify.folsom.client.CallbackSettableFuture;
import com.spotify.folsom.client.MemcacheEncoder;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.SetRequest;
import com.spotify.folsom.client.SimpleSizeEstimator;
import com.spotify.folsom.client.TcpTuningHandler;
import com.spotify.folsom.client.TimeoutChecker;
import com.spotify.folsom.client.ascii.AsciiMemcacheDecoder;
import com.spotify.folsom.client.binary.BinaryMemcacheDecoder;
import com.spotify.folsom.client.binary.BinaryRequest;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRawMemcacheClient
extends AbstractRawMemcacheClient {
    private static final DefaultThreadFactory DAEMON_THREAD_FACTORY = new DefaultThreadFactory(DefaultRawMemcacheClient.class, true);
    private static final EventLoopGroup EVENT_LOOP_GROUP = new NioEventLoopGroup(0, (ThreadFactory)DAEMON_THREAD_FACTORY);
    private final Logger log = LoggerFactory.getLogger(DefaultRawMemcacheClient.class);
    private final AtomicInteger pendingCounter = new AtomicInteger();
    private final int outstandingRequestLimit;
    private final Channel channel;
    private final BatchFlusher flusher;
    private final HostAndPort address;
    private final Executor executor;
    private final long timeoutMillis;
    private final int maxSetLength;
    private final AtomicReference<String> disconnectReason = new AtomicReference<Object>(null);
    private int requestSequenceId = 0;

    public static ListenableFuture<RawMemcacheClient> connect(final HostAndPort address, final int outstandingRequestLimit, boolean binary, final Executor executor, final long timeoutMillis, Charset charset, final Metrics metrics, final int maxSetLength) {
        ByteToMessageDecoder decoder = binary ? new BinaryMemcacheDecoder() : new AsciiMemcacheDecoder(charset);
        ChannelInitializer<Channel> initializer = new ChannelInitializer<Channel>((ChannelInboundHandler)decoder){
            final /* synthetic */ ChannelInboundHandler val$decoder;
            {
                this.val$decoder = channelInboundHandler;
            }

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new TcpTuningHandler(), this.val$decoder, new MemcacheEncoder()});
            }
        };
        final SettableFuture clientFuture = SettableFuture.create();
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(EVENT_LOOP_GROUP)).handler((ChannelHandler)initializer)).channel(NioSocketChannel.class)).option(ChannelOption.MESSAGE_SIZE_ESTIMATOR, (Object)SimpleSizeEstimator.INSTANCE);
        ChannelFuture connectFuture = bootstrap.connect((SocketAddress)new InetSocketAddress(address.getHostText(), address.getPort()));
        connectFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    DefaultRawMemcacheClient client = new DefaultRawMemcacheClient(address, future.channel(), outstandingRequestLimit, executor, timeoutMillis, metrics, maxSetLength);
                    clientFuture.set((Object)client);
                } else {
                    clientFuture.setException(future.cause());
                }
            }
        });
        return DefaultRawMemcacheClient.onExecutor(clientFuture, executor);
    }

    private DefaultRawMemcacheClient(HostAndPort address, Channel channel, int outstandingRequestLimit, Executor executor, long timeoutMillis, Metrics metrics, int maxSetLength) {
        this.address = address;
        this.executor = executor;
        this.timeoutMillis = timeoutMillis;
        this.maxSetLength = maxSetLength;
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.flusher = new BatchFlusher(channel);
        this.outstandingRequestLimit = outstandingRequestLimit;
        metrics.registerOutstandingRequestsGauge(new Metrics.OutstandingRequestsGauge(){

            @Override
            public int getOutstandingRequests() {
                return DefaultRawMemcacheClient.this.pendingCounter.get();
            }
        });
        channel.pipeline().addLast("handler", (ChannelHandler)new ConnectionHandler());
    }

    @Override
    public <T> ListenableFuture<T> send(Request<T> request) {
        SetRequest setRequest;
        byte[] value;
        if (!this.tryIncrementPending()) {
            String disconnectReason = this.disconnectReason.get();
            if (disconnectReason != null) {
                MemcacheClosedException exception = new MemcacheClosedException(disconnectReason);
                return this.onExecutor(Futures.immediateFailedFuture((Throwable)exception));
            }
            return this.onExecutor(Futures.immediateFailedFuture((Throwable)new MemcacheOverloadedException("too many outstanding requests")));
        }
        if (request instanceof SetRequest && (value = (setRequest = (SetRequest)((Object)request)).getValue()).length > this.maxSetLength) {
            return this.onExecutor(Futures.immediateFuture((Object)((Object)MemcacheStatus.VALUE_TOO_LARGE)));
        }
        this.channel.write(request, (ChannelPromise)new RequestWritePromise(this.channel, request));
        this.flusher.flush();
        return this.onExecutor((ListenableFuture<T>)request);
    }

    private <T> ListenableFuture<T> onExecutor(ListenableFuture<T> future) {
        return DefaultRawMemcacheClient.onExecutor(future, this.executor);
    }

    private static <T> ListenableFuture<T> onExecutor(ListenableFuture<T> future, Executor executor) {
        if (executor == null) {
            return future;
        }
        CallbackSettableFuture<T> newFuture = new CallbackSettableFuture<T>(future);
        future.addListener(newFuture, executor);
        return newFuture;
    }

    private boolean tryIncrementPending() {
        int pending;
        do {
            if ((pending = this.pendingCounter.get()) < this.outstandingRequestLimit) continue;
            return false;
        } while (!this.pendingCounter.compareAndSet(pending, pending + 1));
        return true;
    }

    @Override
    public void shutdown() {
        this.channel.close();
    }

    @Override
    public boolean isConnected() {
        return this.disconnectReason.get() == null;
    }

    @Override
    public int numTotalConnections() {
        return 1;
    }

    @Override
    public int numActiveConnections() {
        return this.isConnected() ? 1 : 0;
    }

    private boolean isLostConnection(Throwable t) {
        if (t instanceof IOException) {
            String message = t.getMessage();
            if (t instanceof ConnectException) {
                return message.startsWith("Connection refused:");
            }
            if (message.equals("Broken pipe")) {
                return true;
            }
            return message.equals("Connection reset by peer");
        }
        return false;
    }

    public String toString() {
        return "DefaultRawMemcacheClient(" + this.address + ")";
    }

    private void setDisconnected(Throwable cause) {
        String message = cause.getMessage();
        if (message == null) {
            message = cause.getClass().getSimpleName();
        }
        this.setDisconnected(message);
    }

    private void setDisconnected(String message) {
        if (this.disconnectReason.compareAndSet(null, message)) {
            this.pendingCounter.set(Math.max(0x3FFFFFFF, this.outstandingRequestLimit));
            this.notifyConnectionChange();
        }
    }

    private class RequestWritePromise
    extends DefaultChannelPromise {
        private final Request<?> request;

        public RequestWritePromise(Channel channel, Request<?> request) {
            super(channel);
            this.request = request;
        }

        public ChannelPromise setFailure(Throwable cause) {
            super.setFailure(cause);
            this.fail(cause);
            return this;
        }

        public boolean tryFailure(Throwable cause) {
            if (super.tryFailure(cause)) {
                this.fail(cause);
                return true;
            }
            return false;
        }

        private void fail(Throwable cause) {
            DefaultRawMemcacheClient.this.setDisconnected(cause);
            this.request.fail(new MemcacheClosedException((String)DefaultRawMemcacheClient.this.disconnectReason.get()));
        }
    }

    private class ConnectionHandler
    extends ChannelDuplexHandler {
        private final Queue<Request<?>> outstanding = Queues.newArrayDeque();
        private final TimeoutChecker<Request<?>> timeoutChecker = TimeoutChecker.create(TimeUnit.MILLISECONDS, DefaultRawMemcacheClient.access$200(DefaultRawMemcacheClient.this));
        private final Future<?> timeoutCheckTask;

        ConnectionHandler() {
            long pollIntervalMillis = Math.min(DefaultRawMemcacheClient.this.timeoutMillis, TimeUnit.SECONDS.toMillis(1L));
            this.timeoutCheckTask = DefaultRawMemcacheClient.this.channel.eventLoop().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    Request head = (Request)((Object)ConnectionHandler.this.outstanding.peek());
                    if (head == null) {
                        return;
                    }
                    if (ConnectionHandler.this.timeoutChecker.check(head)) {
                        DefaultRawMemcacheClient.this.log.error("Request timeout: {} {}", (Object)DefaultRawMemcacheClient.this.channel, (Object)head);
                        DefaultRawMemcacheClient.this.setDisconnected("Timeout");
                        DefaultRawMemcacheClient.this.channel.close();
                    }
                }
            }, pollIntervalMillis, pollIntervalMillis, TimeUnit.MILLISECONDS);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            Request request = (Request)((Object)msg);
            if (request instanceof BinaryRequest) {
                ((BinaryRequest)request).setOpaque(++DefaultRawMemcacheClient.this.requestSequenceId);
            }
            this.outstanding.add(request);
            super.write(ctx, msg, promise);
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            this.timeoutCheckTask.cancel(true);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            Request<?> request;
            DefaultRawMemcacheClient.this.setDisconnected("Disconnected");
            while ((request = this.outstanding.poll()) != null) {
                request.fail(new MemcacheClosedException((String)DefaultRawMemcacheClient.this.disconnectReason.get()));
            }
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            Request<?> request = this.outstanding.poll();
            if (request == null) {
                throw new Exception("Unexpected response: " + msg);
            }
            DefaultRawMemcacheClient.this.pendingCounter.decrementAndGet();
            try {
                request.handle(msg);
            }
            catch (Exception exception) {
                DefaultRawMemcacheClient.this.log.error("Corrupt protocol: " + exception.getMessage(), (Throwable)exception);
                DefaultRawMemcacheClient.this.setDisconnected(exception);
                request.fail(new MemcacheClosedException((String)DefaultRawMemcacheClient.this.disconnectReason.get()));
                ctx.channel().close();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof DecoderException) {
                DefaultRawMemcacheClient.this.setDisconnected(cause.getCause());
            } else if (!DefaultRawMemcacheClient.this.isLostConnection(cause)) {
                DefaultRawMemcacheClient.this.log.error("Unexpected error, closing connection", cause);
                DefaultRawMemcacheClient.this.setDisconnected(cause);
            }
            ctx.close();
        }
    }
}

