/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.ascii.AsciiRequest;
import com.spotify.folsom.client.ascii.AsciiResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class TouchRequest
extends AsciiRequest<MemcacheStatus> {
    private static final byte[] CMD = "touch ".getBytes();
    private final int ttl;

    public TouchRequest(String key, Charset charset, int ttl) {
        super(key, charset);
        this.ttl = ttl;
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        dst.put(CMD);
        dst.put(this.key);
        dst.put((byte)32);
        dst.put(String.valueOf(this.ttl).getBytes());
        dst.put(NEWLINE_BYTES);
        return TouchRequest.toBuffer(alloc, dst);
    }

    @Override
    protected void handle(AsciiResponse response) throws IOException {
        AsciiResponse.Type type = response.type;
        if (type == AsciiResponse.Type.TOUCHED) {
            this.succeed(MemcacheStatus.OK);
        } else if (type == AsciiResponse.Type.NOT_FOUND) {
            this.succeed(MemcacheStatus.KEY_NOT_FOUND);
        } else {
            throw new IOException("Unexpected line: " + (Object)((Object)type));
        }
    }
}

