/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.OpCode;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.binary.BinaryRequest;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class SetRequest
extends BinaryRequest<MemcacheStatus>
implements com.spotify.folsom.client.SetRequest {
    private final byte opcode;
    private final byte[] value;
    private final int ttl;
    private final long cas;

    public SetRequest(byte opcode, String key, Charset charset, byte[] value, int ttl, long cas) {
        super(key, charset);
        this.opcode = opcode;
        this.value = value;
        this.ttl = ttl;
        this.cas = cas;
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        int expiration = Utils.ttlToExpiration(this.ttl);
        int valueLength = this.value.length;
        boolean hasExtra = this.opcode == 1 || this.opcode == 2 || this.opcode == 3;
        int extraLength = hasExtra ? 8 : 0;
        this.writeHeader(dst, this.opcode, extraLength, valueLength, this.cas);
        if (hasExtra) {
            dst.putInt(0);
            dst.putInt(expiration);
        }
        dst.put(this.key);
        if (dst.remaining() >= valueLength) {
            dst.put(this.value);
            return SetRequest.toBuffer(alloc, dst);
        }
        return SetRequest.toBufferWithValue(alloc, dst, this.value);
    }

    private static ByteBuf toBufferWithValue(ByteBufAllocator alloc, ByteBuffer dst, byte[] value) {
        ByteBuf buffer = SetRequest.toBuffer(alloc, dst, value.length);
        buffer.writeBytes(value);
        return buffer;
    }

    @Override
    public void handle(BinaryResponse replies) throws IOException {
        ResponsePacket reply = this.handleSingleReply(replies);
        if (OpCode.getKind(reply.opcode) != 1) {
            throw new IOException("Unmatched response");
        }
        MemcacheStatus status = reply.status;
        if (status == MemcacheStatus.KEY_EXISTS && this.opcode == 2) {
            status = MemcacheStatus.ITEM_NOT_STORED;
        } else if (status == MemcacheStatus.KEY_NOT_FOUND && (this.opcode == 14 || this.opcode == 15)) {
            status = MemcacheStatus.ITEM_NOT_STORED;
        }
        this.succeed(status);
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }
}

