/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.ketama;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.ketama.AddressAndClient;
import com.spotify.folsom.ketama.Hasher;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class Continuum {
    private static final int VNODE_RATIO = 100;
    private final TreeMap<Integer, RawMemcacheClient> ringOfFire;

    public Continuum(Collection<AddressAndClient> clients) {
        this.ringOfFire = this.buildRing(clients);
    }

    private TreeMap<Integer, RawMemcacheClient> buildRing(Collection<AddressAndClient> clients) {
        TreeMap r = Maps.newTreeMap();
        for (AddressAndClient client : clients) {
            String address = client.getAddress().toString();
            byte[] hash = Continuum.addressToBytes(address);
            for (int i = 0; i < 100; ++i) {
                HashCode hashCode = Hasher.hash(hash);
                hash = hashCode.asBytes();
                r.put(hashCode.asInt(), client.getClient());
            }
        }
        return r;
    }

    public RawMemcacheClient findClient(byte[] key) {
        int keyHash = Hasher.hash(key).asInt();
        Map.Entry<Integer, RawMemcacheClient> entry = this.ringOfFire.ceilingEntry(keyHash);
        if (entry == null) {
            entry = this.ringOfFire.firstEntry();
        }
        for (int i = 0; i < this.ringOfFire.size(); ++i) {
            RawMemcacheClient client = this.findClient(entry);
            if (client.isConnected()) {
                return client;
            }
            if ((entry = this.ringOfFire.higherEntry(entry.getKey())) != null) continue;
            entry = this.ringOfFire.firstEntry();
        }
        return this.ringOfFire.firstEntry().getValue();
    }

    private RawMemcacheClient findClient(Map.Entry<Integer, RawMemcacheClient> entry) {
        Preconditions.checkNotNull(entry);
        return entry.getValue();
    }

    private static byte[] addressToBytes(String s) {
        int length = s.length();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)s.charAt(i);
        }
        return bytes;
    }
}

