/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.ketama;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.client.AbstractMultiMemcacheClient;
import com.spotify.folsom.client.MultiRequest;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.ketama.AddressAndClient;
import com.spotify.folsom.ketama.Continuum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class KetamaMemcacheClient
extends AbstractMultiMemcacheClient {
    private final Continuum continuum;

    private static Collection<RawMemcacheClient> clientsOnly(Collection<AddressAndClient> addressAndClients) {
        int size = addressAndClients.size();
        ArrayList clients = Lists.newArrayListWithCapacity((int)size);
        for (AddressAndClient client : addressAndClients) {
            clients.add(client.getClient());
        }
        return clients;
    }

    public KetamaMemcacheClient(Collection<AddressAndClient> clients) {
        super(KetamaMemcacheClient.clientsOnly(clients));
        this.continuum = new Continuum(clients);
    }

    private RawMemcacheClient getClient(byte[] key) {
        return this.continuum.findClient(key);
    }

    @Override
    public <T> ListenableFuture<T> send(Request<T> request) {
        MultiRequest multiRequest;
        if (request instanceof MultiRequest && (multiRequest = (MultiRequest)((Object)request)).getKeys().size() > 1) {
            return this.sendSplitRequest(multiRequest);
        }
        return this.getClient(request.getKey()).send(request);
    }

    private <T> ListenableFuture<List<T>> sendSplitRequest(MultiRequest<T> multiRequest) {
        List subKeys;
        Object key2;
        List<byte[]> keys = multiRequest.getKeys();
        IdentityHashMap routing = Maps.newIdentityHashMap();
        ArrayList routing2 = Lists.newArrayListWithCapacity((int)keys.size());
        for (Object key2 : keys) {
            RawMemcacheClient client = this.getClient((byte[])key2);
            subKeys = (List)routing.get(client);
            if (subKeys == null) {
                subKeys = Lists.newArrayList();
                routing.put(client, subKeys);
            }
            subKeys.add(key2);
            routing2.add(client);
        }
        IdentityHashMap futures = Maps.newIdentityHashMap();
        key2 = routing.entrySet().iterator();
        while (key2.hasNext()) {
            Map.Entry entry = (Map.Entry)key2.next();
            subKeys = (List)entry.getValue();
            Request<List<T>> subRequest = multiRequest.create(subKeys);
            RawMemcacheClient client = (RawMemcacheClient)entry.getKey();
            ListenableFuture<List<T>> send = client.send(subRequest);
            futures.put(client, send);
        }
        ListenableFuture allFutures = Futures.allAsList(futures.values());
        return Utils.transform(allFutures, new Assembler(futures, routing2));
    }

    private static class Assembler<T, R>
    implements Function<List<List<T>>, List<T>> {
        private final Map<R, ListenableFuture<List<T>>> futures;
        private final List<R> routing2;

        public Assembler(Map<R, ListenableFuture<List<T>>> futures, List<R> routing2) {
            this.futures = futures;
            this.routing2 = routing2;
        }

        public List<T> apply(List<List<T>> ignored) {
            IdentityHashMap map = Maps.newIdentityHashMap();
            for (Map.Entry<R, ListenableFuture<List<T>>> entry : this.futures.entrySet()) {
                R client = entry.getKey();
                map.put(client, ((List)Futures.getUnchecked((Future)((Future)entry.getValue()))).iterator());
            }
            ArrayList result = Lists.newArrayList();
            for (R memcacheClient : this.routing2) {
                Iterator iterator = (Iterator)map.get(memcacheClient);
                result.add(iterator.next());
            }
            return result;
        }
    }
}

