/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.retry;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.folsom.ConnectionChangeListener;
import com.spotify.folsom.MemcacheClosedException;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.client.Request;

public class RetryingClient
implements RawMemcacheClient {
    private final RawMemcacheClient delegate;

    public RetryingClient(RawMemcacheClient delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> ListenableFuture<T> send(final Request<T> request) {
        ListenableFuture<T> future = this.delegate.send(request);
        return Futures.catchingAsync(future, MemcacheClosedException.class, (AsyncFunction)new AsyncFunction<MemcacheClosedException, T>(){

            public ListenableFuture<T> apply(MemcacheClosedException e) {
                if (RetryingClient.this.delegate.isConnected()) {
                    return RetryingClient.this.delegate.send(request);
                }
                return Futures.immediateFailedFuture((Throwable)e);
            }
        });
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public boolean isConnected() {
        return this.delegate.isConnected();
    }

    @Override
    public int numTotalConnections() {
        return this.delegate.numTotalConnections();
    }

    @Override
    public int numActiveConnections() {
        return this.delegate.numActiveConnections();
    }

    @Override
    public void registerForConnectionChanges(ConnectionChangeListener listener) {
        this.delegate.registerForConnectionChanges(listener);
    }

    @Override
    public void unregisterForConnectionChanges(ConnectionChangeListener listener) {
        this.delegate.unregisterForConnectionChanges(listener);
    }

    public String toString() {
        return "Retrying(" + this.delegate + ")";
    }
}

