/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.folsom.ConnectionChangeListener;
import com.spotify.folsom.ObservableClient;

public class ConnectFuture
extends AbstractFuture<Void>
implements ConnectionChangeListener {
    private final boolean awaitedState;

    private ConnectFuture(ObservableClient client, boolean awaitedState) {
        this.awaitedState = awaitedState;
        client.registerForConnectionChanges(this);
        this.check(client);
    }

    public static ListenableFuture<Void> disconnectFuture(ObservableClient client) {
        return new ConnectFuture(client, false);
    }

    public static ListenableFuture<Void> connectFuture(ObservableClient client) {
        return new ConnectFuture(client, true);
    }

    @Override
    public void connectionChanged(ObservableClient client) {
        this.check(client);
    }

    private void check(ObservableClient client) {
        if (this.awaitedState == client.isConnected() && this.set(null)) {
            client.unregisterForConnectionChanges(this);
        }
    }
}

