/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.folsom.client.DefaultRawMemcacheClient;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    public static final Executor SAME_THREAD_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable command) {
            try {
                command.run();
            }
            catch (Exception e) {
                log.error("caught exception", (Throwable)e);
            }
        }
    };

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function) {
        return Futures.transformAsync(input, function, (Executor)SAME_THREAD_EXECUTOR);
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function) {
        return Futures.transform(input, function, (Executor)SAME_THREAD_EXECUTOR);
    }

    private Utils() {
    }

    public static int ttlToExpiration(int ttl) {
        return ttl == 0 ? 0 : (int)(System.currentTimeMillis() / 1000L) + ttl;
    }

    public static <T> Function<List<List<T>>, List<T>> flatten() {
        return new Function<List<List<T>>, List<T>>(){

            public List<T> apply(List<List<T>> input) {
                return Lists.newArrayList((Iterable)Iterables.concat(input));
            }
        };
    }

    public static int getGlobalConnectionCount() {
        return DefaultRawMemcacheClient.getGlobalConnectionCount();
    }
}

