/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.spotify.folsom.GetResult;
import com.spotify.folsom.client.MultiRequest;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.ascii.AsciiRequest;
import com.spotify.folsom.client.ascii.AsciiResponse;
import com.spotify.folsom.client.ascii.ValueAsciiResponse;
import com.spotify.folsom.client.ascii.ValueResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultigetRequest
extends AsciiRequest<List<GetResult<byte[]>>>
implements MultiRequest<GetResult<byte[]>> {
    private static final byte[] GET = "get ".getBytes(Charsets.US_ASCII);
    private static final byte[] CAS_GET = "gets ".getBytes(Charsets.US_ASCII);
    private final List<byte[]> keys;
    private final byte[] cmd;

    private MultigetRequest(List<byte[]> keys, byte[] cmd) {
        super(keys.get(0));
        this.cmd = cmd;
        this.keys = keys;
    }

    public static MultigetRequest create(List<String> keys, Charset charset, boolean withCas) {
        byte[] cmd = withCas ? CAS_GET : GET;
        int size = keys.size();
        if (size > 255) {
            throw new IllegalArgumentException("Too large multiget request");
        }
        return new MultigetRequest(MultigetRequest.encodeKeys(keys, charset), cmd);
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        dst.put(this.cmd);
        for (byte[] key : this.keys) {
            dst.put((byte)32);
            dst.put(key);
        }
        dst.put(NEWLINE_BYTES);
        return MultigetRequest.toBuffer(alloc, dst);
    }

    @Override
    public void handle(AsciiResponse response) throws IOException {
        if (!(response instanceof ValueAsciiResponse)) {
            throw new IOException("Unexpected response type: " + (Object)((Object)response.type));
        }
        List<ValueResponse> values = ((ValueAsciiResponse)response).values;
        int size = this.keys.size();
        if (values.size() > size) {
            throw new IOException("Too many responses, expected " + size + " but got " + values.size());
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)size);
        for (int i = 0; i < size; ++i) {
            result.add(null);
        }
        int index = -1;
        for (ValueResponse value : values) {
            if ((index = this.findKey(index + 1, value.key)) < 0) {
                throw new IOException("Got key in value that was not present in request");
            }
            result.set(index, GetResult.success(value.value, value.cas));
        }
        this.succeed(result);
    }

    private int findKey(int index, byte[] key) {
        int size = this.keys.size();
        while (index < size) {
            byte[] candidate = this.keys.get(index);
            if (Arrays.equals(key, candidate)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public List<byte[]> getKeys() {
        return this.keys;
    }

    @Override
    public Request<List<GetResult<byte[]>>> create(List<byte[]> keys) {
        return new MultigetRequest(keys, this.cmd);
    }
}

