/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class BinaryRequest<V>
extends Request<V> {
    protected static final int HEADER_SIZE = 24;
    protected static final byte MAGIC_NUMBER = -128;
    protected int opaque;
    protected boolean opaqueSet;

    protected BinaryRequest(String key, Charset charset) {
        this(BinaryRequest.encodeKey(key, charset));
    }

    protected BinaryRequest(byte[] key) {
        super(key);
    }

    protected int getOpaque() {
        if (!this.opaqueSet) {
            throw new IllegalStateException("opaque must be set before write");
        }
        return this.opaque;
    }

    public void writeHeader(ByteBuffer dst, byte opCode, int extraLength, int valueLength, long cas) {
        int keyLength = this.key.length;
        dst.put((byte)-128);
        dst.put(opCode);
        dst.putShort((short)keyLength);
        dst.put((byte)extraLength);
        dst.put((byte)0);
        dst.put((byte)0);
        dst.put((byte)0);
        dst.putInt(extraLength + keyLength + valueLength);
        dst.putInt(this.getOpaque());
        dst.putLong(cas);
    }

    protected ResponsePacket handleSingleReply(BinaryResponse replies) throws IOException {
        if (replies.size() != 1) {
            throw new IOException("got " + replies.size() + " replies but expected 1 for " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        ResponsePacket reply = (ResponsePacket)replies.get(0);
        if (reply.opaque != this.getOpaque()) {
            throw new IOException("messages out of order for " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        return reply;
    }

    @Override
    public void handle(Object response) throws IOException {
        this.handle((BinaryResponse)response);
    }

    protected abstract void handle(BinaryResponse var1) throws IOException;

    public void setOpaque(int opaque) {
        this.opaqueSet = true;
        this.opaque = opaque << 8 & 0xFFFFFF00;
    }
}

