/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.folsom.BinaryMemcacheClient;
import com.spotify.folsom.ConnectionChangeListener;
import com.spotify.folsom.GetResult;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.Metrics;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.Transcoder;
import com.spotify.folsom.client.TransformerUtil;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.binary.DeleteRequest;
import com.spotify.folsom.client.binary.GetRequest;
import com.spotify.folsom.client.binary.IncrRequest;
import com.spotify.folsom.client.binary.MultigetRequest;
import com.spotify.folsom.client.binary.NoopRequest;
import com.spotify.folsom.client.binary.SetRequest;
import com.spotify.folsom.client.binary.TouchRequest;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultBinaryMemcacheClient<V>
implements BinaryMemcacheClient<V> {
    private final RawMemcacheClient rawMemcacheClient;
    private final Metrics metrics;
    private final Transcoder<V> valueTranscoder;
    private final TransformerUtil<V> transformerUtil;
    private final Charset charset;

    public DefaultBinaryMemcacheClient(RawMemcacheClient rawMemcacheClient, Metrics metrics, Transcoder<V> valueTranscoder, Charset charset) {
        this.rawMemcacheClient = rawMemcacheClient;
        this.metrics = metrics;
        this.valueTranscoder = valueTranscoder;
        this.charset = charset;
        this.transformerUtil = new TransformerUtil<V>(valueTranscoder);
    }

    @Override
    public ListenableFuture<MemcacheStatus> set(String key, V value, int ttl) {
        return this.setInternal((byte)1, key, value, ttl);
    }

    @Override
    public ListenableFuture<MemcacheStatus> set(String key, V value, int ttl, long cas) {
        return this.casSetInternal((byte)1, key, value, ttl, cas);
    }

    @Override
    public ListenableFuture<MemcacheStatus> add(String key, V value, int ttl) {
        return this.setInternal((byte)2, key, value, ttl);
    }

    @Override
    public ListenableFuture<MemcacheStatus> replace(String key, V value, int ttl) {
        return this.setInternal((byte)3, key, value, ttl);
    }

    private ListenableFuture<MemcacheStatus> setInternal(byte opcode, String key, V value, int ttl) {
        return this.casSetInternal(opcode, key, value, ttl, 0L);
    }

    @Override
    public ListenableFuture<MemcacheStatus> add(String key, V value, int ttl, long cas) {
        return this.casSetInternal((byte)2, key, value, ttl, cas);
    }

    @Override
    public ListenableFuture<MemcacheStatus> replace(String key, V value, int ttl, long cas) {
        return this.casSetInternal((byte)3, key, value, ttl, cas);
    }

    private ListenableFuture<MemcacheStatus> casSetInternal(byte opcode, String key, V value, int ttl, long cas) {
        Preconditions.checkNotNull(value);
        byte[] valueBytes = this.valueTranscoder.encode(value);
        SetRequest request = new SetRequest(opcode, key, this.charset, valueBytes, ttl, cas);
        ListenableFuture<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureSetFuture(future);
        return future;
    }

    @Override
    public ListenableFuture<V> get(String key) {
        return this.getAndTouch(key, -1);
    }

    @Override
    public ListenableFuture<V> getAndTouch(String key, int ttl) {
        return this.transformerUtil.unwrap(this.casGetAndTouch(key, ttl));
    }

    @Override
    public ListenableFuture<List<V>> get(List<String> keys) {
        return this.getAndTouch(keys, -1);
    }

    @Override
    public ListenableFuture<GetResult<V>> casGet(String key) {
        return this.getInternal(key, -1);
    }

    private ListenableFuture<GetResult<V>> getInternal(String key, int ttl) {
        byte opCode = ttl > -1 ? (byte)29 : 0;
        GetRequest request = new GetRequest(key, this.charset, opCode, ttl);
        ListenableFuture<GetResult<byte[]>> future = this.rawMemcacheClient.send(request);
        this.metrics.measureGetFuture(future);
        return this.transformerUtil.decode(future);
    }

    @Override
    public ListenableFuture<List<GetResult<V>>> casGet(List<String> keys) {
        return this.multiget(keys, -1);
    }

    private ListenableFuture<List<GetResult<V>>> multiget(List<String> keys, int ttl) {
        int size = keys.size();
        if (size == 0) {
            return Futures.immediateFuture(Collections.emptyList());
        }
        List keyPartition = Lists.partition(keys, (int)255);
        ArrayList<ListenableFuture<List<GetResult<byte[]>>>> futureList = new ArrayList<ListenableFuture<List<GetResult<byte[]>>>>(keyPartition.size());
        for (List part : keyPartition) {
            MultigetRequest request = MultigetRequest.create(part, this.charset, ttl);
            futureList.add(this.rawMemcacheClient.send(request));
        }
        ListenableFuture future = Utils.transform(Futures.allAsList(futureList), Utils.flatten());
        this.metrics.measureMultigetFuture(future);
        return this.transformerUtil.decodeList(future);
    }

    @Override
    public ListenableFuture<List<V>> getAndTouch(List<String> keys, int ttl) {
        return this.transformerUtil.unwrapList(this.multiget(keys, ttl));
    }

    @Override
    public ListenableFuture<GetResult<V>> casGetAndTouch(String key, int ttl) {
        return this.getInternal(key, ttl);
    }

    @Override
    public ListenableFuture<MemcacheStatus> touch(String key, int ttl) {
        TouchRequest request = new TouchRequest(key, this.charset, ttl);
        ListenableFuture<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureTouchFuture(future);
        return future;
    }

    @Override
    public ListenableFuture<MemcacheStatus> delete(String key) {
        DeleteRequest request = new DeleteRequest(key, this.charset);
        ListenableFuture<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureDeleteFuture(future);
        return future;
    }

    @Override
    public ListenableFuture<Long> incr(String key, long by, long initial, int ttl) {
        return this.incrInternal((byte)5, key, by, initial, ttl);
    }

    private ListenableFuture<Long> incrInternal(byte opcode, String key, long by, long initial, int ttl) {
        ListenableFuture<Long> future = this.rawMemcacheClient.send(new IncrRequest(key, this.charset, opcode, by, initial, ttl));
        this.metrics.measureIncrDecrFuture(future);
        return future;
    }

    @Override
    public ListenableFuture<Long> decr(String key, long by, long initial, int ttl) {
        return this.incrInternal((byte)6, key, by, initial, ttl);
    }

    @Override
    public ListenableFuture<MemcacheStatus> append(String key, V value) {
        return this.casSetInternal((byte)14, key, value, 0, 0L);
    }

    @Override
    public ListenableFuture<MemcacheStatus> append(String key, V value, long cas) {
        return this.casSetInternal((byte)14, key, value, 0, cas);
    }

    @Override
    public ListenableFuture<MemcacheStatus> prepend(String key, V value) {
        return this.casSetInternal((byte)15, key, value, 0, 0L);
    }

    @Override
    public ListenableFuture<MemcacheStatus> prepend(String key, V value, long cas) {
        return this.casSetInternal((byte)15, key, value, 0, cas);
    }

    @Override
    public ListenableFuture<Void> noop() {
        return this.rawMemcacheClient.send(new NoopRequest());
    }

    @Override
    public void shutdown() {
        this.rawMemcacheClient.shutdown();
    }

    @Override
    public void registerForConnectionChanges(ConnectionChangeListener listener) {
        this.rawMemcacheClient.registerForConnectionChanges(listener);
    }

    @Override
    public void unregisterForConnectionChanges(ConnectionChangeListener listener) {
        this.rawMemcacheClient.registerForConnectionChanges(listener);
    }

    @Override
    public boolean isConnected() {
        return this.rawMemcacheClient.isConnected();
    }

    @Override
    public int numTotalConnections() {
        return this.rawMemcacheClient.numTotalConnections();
    }

    @Override
    public int numActiveConnections() {
        return this.rawMemcacheClient.numActiveConnections();
    }

    @Override
    public RawMemcacheClient getRawMemcacheClient() {
        return this.rawMemcacheClient;
    }

    public String toString() {
        return "BinaryMemcacheClient(" + this.rawMemcacheClient + ")";
    }
}

