/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.google.common.base.Preconditions;
import com.spotify.folsom.GetResult;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.OpCode;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.binary.BinaryRequest;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class GetRequest
extends BinaryRequest<GetResult<byte[]>>
implements com.spotify.folsom.client.GetRequest {
    private final byte opcode;
    private final int ttl;

    public GetRequest(String key, Charset charset, byte opcode, int ttl) {
        super(key, charset);
        this.opcode = (Byte)Preconditions.checkNotNull((Object)opcode, (Object)"opcode");
        this.ttl = (Integer)Preconditions.checkNotNull((Object)ttl, (Object)"ttl");
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        int extrasLength;
        int expiration;
        if (this.ttl > 0) {
            expiration = Utils.ttlToExpiration(this.ttl);
            extrasLength = 4;
        } else {
            expiration = 0;
            extrasLength = 0;
        }
        this.writeHeader(dst, this.opcode, extrasLength, 0, 0L);
        if (this.ttl > 0) {
            dst.putInt(expiration);
        }
        dst.put(this.key);
        return GetRequest.toBuffer(alloc, dst);
    }

    @Override
    public void handle(BinaryResponse replies) throws IOException {
        ResponsePacket reply = this.handleSingleReply(replies);
        if (OpCode.getKind(reply.opcode) != 0) {
            throw new IOException("Unmatched response");
        }
        if (reply.status == MemcacheStatus.OK) {
            this.succeed(GetResult.success(reply.value, reply.cas));
        } else if (reply.status == MemcacheStatus.KEY_NOT_FOUND) {
            this.succeed(null);
        } else {
            throw new IOException("Unexpected response: " + (Object)((Object)reply.status));
        }
    }
}

