/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.reconnect;

import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.spotify.folsom.AbstractRawMemcacheClient;
import com.spotify.folsom.BackoffFunction;
import com.spotify.folsom.ConnectFuture;
import com.spotify.folsom.Metrics;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.client.DefaultRawMemcacheClient;
import com.spotify.folsom.client.NotConnectedClient;
import com.spotify.folsom.client.Request;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectingClient
extends AbstractRawMemcacheClient {
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("folsom-reconnecter").build());
    private final Logger log = LoggerFactory.getLogger(ReconnectingClient.class);
    private final BackoffFunction backoffFunction;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Connector connector;
    private final HostAndPort address;
    private volatile RawMemcacheClient client = NotConnectedClient.INSTANCE;
    private volatile int reconnectCount = 0;
    private volatile boolean stayConnected = true;

    public ReconnectingClient(BackoffFunction backoffFunction, ScheduledExecutorService scheduledExecutorService, final HostAndPort address, final int outstandingRequestLimit, final boolean binary, final Executor executor, final long timeoutMillis, final Charset charset, final Metrics metrics, final int maxSetLength) {
        this(backoffFunction, scheduledExecutorService, new Connector(){

            @Override
            public ListenableFuture<RawMemcacheClient> connect() {
                return DefaultRawMemcacheClient.connect(address, outstandingRequestLimit, binary, executor, timeoutMillis, charset, metrics, maxSetLength);
            }
        }, address);
    }

    ReconnectingClient(BackoffFunction backoffFunction, ScheduledExecutorService scheduledExecutorService, Connector connector, HostAndPort address) {
        this.backoffFunction = backoffFunction;
        this.scheduledExecutorService = scheduledExecutorService;
        this.connector = connector;
        this.address = address;
        this.retry();
    }

    @Override
    public <T> ListenableFuture<T> send(Request<T> request) {
        return this.client.send(request);
    }

    @Override
    public void shutdown() {
        this.stayConnected = false;
        this.client.shutdown();
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public int numTotalConnections() {
        return this.client.numTotalConnections();
    }

    @Override
    public int numActiveConnections() {
        return this.client.numActiveConnections();
    }

    private void retry() {
        try {
            ListenableFuture<RawMemcacheClient> future = this.connector.connect();
            Futures.addCallback(future, (FutureCallback)new FutureCallback<RawMemcacheClient>(){

                public void onSuccess(RawMemcacheClient newClient) {
                    ReconnectingClient.this.log.info("Successfully connected to {}", (Object)ReconnectingClient.this.address);
                    ReconnectingClient.this.reconnectCount = 0;
                    ReconnectingClient.this.client.shutdown();
                    ReconnectingClient.this.client = newClient;
                    if (!ReconnectingClient.this.stayConnected) {
                        newClient.shutdown();
                        ReconnectingClient.this.notifyConnectionChange();
                        return;
                    }
                    ReconnectingClient.this.notifyConnectionChange();
                    ListenableFuture<Void> discFuture = ConnectFuture.disconnectFuture(newClient);
                    Futures.addCallback(discFuture, (FutureCallback)new FutureCallback<Void>(){

                        public void onSuccess(Void ignore) {
                            ReconnectingClient.this.log.info("Lost connection to {}", (Object)ReconnectingClient.this.address);
                            ReconnectingClient.this.notifyConnectionChange();
                            if (ReconnectingClient.this.stayConnected) {
                                ReconnectingClient.this.retry();
                            }
                        }

                        public void onFailure(Throwable t) {
                            throw new RuntimeException("Programmer bug - this should be unreachable");
                        }
                    });
                }

                public void onFailure(Throwable t) {
                    ReconnectingClient.this.onFailure();
                }
            });
        }
        catch (Exception e) {
            this.onFailure();
        }
    }

    private void onFailure() {
        long backOff = this.backoffFunction.getBackoffTimeMillis(this.reconnectCount);
        if (this.stayConnected) {
            this.log.warn("Attempting reconnect to {} in {} ms (retry number {})", new Object[]{this.address, backOff, this.reconnectCount});
        }
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                ReconnectingClient.this.reconnectCount++;
                if (ReconnectingClient.this.stayConnected) {
                    ReconnectingClient.this.retry();
                }
            }
        }, backOff, TimeUnit.MILLISECONDS);
    }

    public static ScheduledExecutorService singletonExecutor() {
        return SCHEDULED_EXECUTOR_SERVICE;
    }

    public String toString() {
        return "Reconnecting(" + this.client + ")";
    }

    static interface Connector {
        public ListenableFuture<RawMemcacheClient> connect();
    }
}

