/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.roundrobin;

import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.client.AbstractMultiMemcacheClient;
import com.spotify.folsom.client.NotConnectedClient;
import com.spotify.folsom.client.Request;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinMemcacheClient
extends AbstractMultiMemcacheClient {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final List<RawMemcacheClient> clients;
    private final int numClients;

    public RoundRobinMemcacheClient(List<RawMemcacheClient> clients) {
        super(clients);
        this.clients = clients;
        this.numClients = clients.size();
    }

    @Override
    public <T> ListenableFuture<T> send(Request<T> request) {
        return this.getClient().send(request);
    }

    private RawMemcacheClient getClient() {
        for (int i = 0; i < this.numClients; ++i) {
            int c = this.counter.incrementAndGet() & Integer.MAX_VALUE;
            int index = c % this.numClients;
            RawMemcacheClient client = this.clients.get(index);
            if (!client.isConnected()) continue;
            return client;
        }
        return NotConnectedClient.INSTANCE;
    }
}

