/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom;

import java.util.Objects;

public class GetResult<V> {
    private final V value;
    private final long cas;
    private final int flags;

    private GetResult(V value, long cas, int flags) {
        this.value = Objects.requireNonNull(value);
        this.cas = cas;
        this.flags = flags;
    }

    public static <V> GetResult<V> success(V value, long cas) {
        return GetResult.success(value, cas, 0);
    }

    public static <V> GetResult<V> success(V value, long cas, int flags) {
        Objects.requireNonNull(value, "value");
        return new GetResult<V>(value, cas, flags);
    }

    public V getValue() {
        return this.value;
    }

    public long getCas() {
        return this.cas;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetResult getResult = (GetResult)o;
        if (this.cas != getResult.cas) {
            return false;
        }
        if (!this.value.equals(getResult.value)) {
            return false;
        }
        return this.flags == getResult.flags;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.cas, this.flags);
    }
}

