/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.spotify.folsom.client.ascii.AsciiResponse;
import com.spotify.folsom.client.ascii.NumericAsciiResponse;
import com.spotify.folsom.client.ascii.StatsAsciiResponse;
import com.spotify.folsom.client.ascii.ValueAsciiResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;

public class AsciiMemcacheDecoder
extends ByteToMessageDecoder {
    private static final int MAX_RESPONSE_LINE = 500;
    private final ByteBuffer line = ByteBuffer.allocate(500);
    private final ByteBuffer token = ByteBuffer.allocate(500);
    private final Charset charset;
    private boolean valueMode = false;
    private ValueAsciiResponse valueResponse = new ValueAsciiResponse();
    private StatsAsciiResponse statsAsciiResponse = new StatsAsciiResponse();
    private boolean consumed;
    private byte[] key = null;
    private byte[] value = null;
    private long cas = 0L;
    private int flags = 0;
    private int valueOffset;

    public AsciiMemcacheDecoder(Charset charset) {
        this.charset = charset;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        byte firstChar;
        int tokenLength;
        while (true) {
            int readableBytes;
            if ((readableBytes = buf.readableBytes()) == 0) {
                return;
            }
            if (this.key != null) {
                ByteBuffer line;
                int toCopy = Math.min(this.value.length - this.valueOffset, readableBytes);
                if (toCopy > 0) {
                    buf.readBytes(this.value, this.valueOffset, toCopy);
                    readableBytes -= toCopy;
                    this.valueOffset += toCopy;
                    if (this.valueOffset < this.value.length) {
                        return;
                    }
                }
                if ((line = this.readLine(buf, readableBytes)) == null) {
                    return;
                }
                if (line.remaining() > 0) {
                    throw new IOException(String.format("Unexpected end of data block: %s", this.toString(line)));
                }
                this.valueResponse.addGetResult(this.key, this.value, this.cas, this.flags);
                this.key = null;
                this.value = null;
                this.cas = 0L;
                this.flags = 0;
                continue;
            }
            ByteBuffer line = this.readLine(buf, readableBytes);
            if (line == null) {
                return;
            }
            this.readNextToken();
            tokenLength = this.token.remaining();
            if (tokenLength < 1) {
                throw this.fail();
            }
            firstChar = this.token.get();
            if (Character.isDigit(firstChar)) {
                try {
                    long numeric = this.parseLong(firstChar, this.token);
                    out.add(new NumericAsciiResponse(numeric));
                }
                catch (NumberFormatException e) {
                    throw new IOException("Unexpected line: " + line, e);
                }
            }
            if (tokenLength == 2) {
                this.expect(firstChar, "OK");
                out.add(AsciiResponse.OK);
                return;
            }
            if (tokenLength == 3) {
                this.expect(firstChar, "END");
                if (!this.valueResponse.isEmpty()) {
                    out.add(this.valueResponse);
                    this.valueResponse = new ValueAsciiResponse();
                    this.valueMode = false;
                    return;
                }
                if (!this.statsAsciiResponse.isEmpty()) {
                    out.add(this.statsAsciiResponse);
                    this.statsAsciiResponse = new StatsAsciiResponse();
                    return;
                }
                out.add(AsciiResponse.EMPTY_LIST);
                return;
            }
            if (tokenLength == 4) {
                this.expect(firstChar, "STAT");
                this.readNextToken();
                if (this.token.remaining() < 1) {
                    throw this.fail();
                }
                String statName = this.toString(this.token);
                this.readNextToken();
                if (this.token.remaining() < 1) {
                    throw this.fail();
                }
                String statValue = this.toString(this.token);
                this.statsAsciiResponse.addStat(statName, statValue);
                continue;
            }
            if (tokenLength != 5) break;
            if (firstChar == 69) {
                this.expect(firstChar, "ERROR");
                out.add(AsciiResponse.ERROR);
                return;
            }
            this.expect(firstChar, "VALUE");
            this.valueMode = true;
            this.readNextToken();
            int keyLen = this.token.remaining();
            if (keyLen <= 0) {
                throw this.fail();
            }
            byte[] key = new byte[this.token.remaining()];
            this.token.get(key);
            this.readNextToken();
            int flagLen = this.token.remaining();
            if (flagLen <= 0) {
                throw this.fail();
            }
            int flags = (int)this.parseLong(this.token.get(), this.token);
            this.readNextToken();
            int sizeLen = this.token.remaining();
            if (sizeLen <= 0) {
                throw this.fail();
            }
            int size = (int)this.parseLong(this.token.get(), this.token);
            this.readNextToken();
            int casLen = this.token.remaining();
            long cas = 0L;
            if (casLen > 0) {
                cas = this.parseLong(this.token.get(), this.token);
            }
            this.key = key;
            this.value = new byte[size];
            this.valueOffset = 0;
            this.cas = cas;
            this.flags = flags;
        }
        if (this.valueMode) {
            throw this.fail();
        }
        if (tokenLength == 6) {
            if (firstChar == 83) {
                this.expect(firstChar, "STORED");
                out.add(AsciiResponse.STORED);
                return;
            }
            this.expect(firstChar, "EXISTS");
            out.add(AsciiResponse.EXISTS);
            return;
        }
        if (tokenLength == 7) {
            if (firstChar == 84) {
                this.expect(firstChar, "TOUCHED");
                out.add(AsciiResponse.TOUCHED);
                return;
            }
            this.expect(firstChar, "DELETED");
            out.add(AsciiResponse.DELETED);
            return;
        }
        if (tokenLength == 9) {
            this.expect(firstChar, "NOT_FOUND");
            out.add(AsciiResponse.NOT_FOUND);
            return;
        }
        if (tokenLength == 10) {
            this.expect(firstChar, "NOT_STORED");
            out.add(AsciiResponse.NOT_STORED);
            return;
        }
        throw this.fail();
    }

    private void readNextToken() {
        byte b;
        this.token.clear();
        while (this.line.hasRemaining() && (b = this.line.get()) != 32) {
            this.token.put(b);
        }
        this.token.flip();
    }

    private IOException fail() {
        return new IOException("Unexpected line: " + this.toString(this.line));
    }

    private String toString(ByteBuffer buf) {
        buf.rewind();
        return new String(buf.array(), 0, buf.remaining(), this.charset);
    }

    private void expect(byte firstChar, String compareTo) throws IOException {
        if (firstChar != compareTo.charAt(0)) {
            throw this.fail();
        }
        int length = compareTo.length();
        if (length != this.token.remaining() + 1) {
            throw this.fail();
        }
        for (int i = 1; i < length; ++i) {
            if (this.token.get() == compareTo.charAt(i)) continue;
            throw this.fail();
        }
    }

    private long parseLong(byte firstChar, ByteBuffer token) throws IOException {
        long res = firstChar - 48;
        if (res < 0L || res > 9L) {
            throw this.fail();
        }
        while (token.hasRemaining()) {
            int digit = token.get() - 48;
            if (digit < 0 || digit > 9) {
                throw this.fail();
            }
            res *= 10L;
            res += (long)digit;
        }
        return res;
    }

    private ByteBuffer readLine(ByteBuf buf, int available) throws IOException {
        if (this.consumed) {
            this.consumed = false;
            this.line.clear();
        }
        for (int i = 0; i < available - 1; ++i) {
            byte b = buf.readByte();
            if (b == 13) {
                if (buf.readByte() == 10) {
                    this.consumed = true;
                    this.line.flip();
                    return this.line;
                }
                throw new IOException("Expected newline, got something else");
            }
            this.line.put(b);
        }
        return null;
    }
}

