/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.spotify.folsom.GetResult;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.MultiRequest;
import com.spotify.folsom.client.OpCode;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.binary.BinaryRequest;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MultigetRequest
extends BinaryRequest<List<GetResult<byte[]>>>
implements MultiRequest<GetResult<byte[]>> {
    private final int ttl;
    private final List<byte[]> keys;

    private MultigetRequest(List<byte[]> keys, int ttl) {
        super(keys.get(0));
        this.keys = keys;
        this.ttl = ttl;
    }

    public static MultigetRequest create(List<byte[]> keys, int ttl) {
        int size = keys.size();
        if (size > 255) {
            throw new IllegalArgumentException("Too large multiget request");
        }
        return new MultigetRequest(keys, ttl);
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        int extrasLength;
        int expiration;
        boolean hasTTL;
        int numKeys = this.keys.size();
        boolean bl = hasTTL = this.ttl > 0;
        if (hasTTL) {
            expiration = Utils.ttlToExpiration(this.ttl);
            extrasLength = 4;
        } else {
            expiration = 0;
            extrasLength = 0;
        }
        int multigetOpaque = this.opaque;
        int sequenceNumber = numKeys;
        for (byte[] key : this.keys) {
            int keyLength = key.length;
            int totalLength = keyLength + extrasLength;
            int opaque = multigetOpaque | --sequenceNumber;
            dst.put((byte)-128);
            dst.put(sequenceNumber == 0 ? OpCode.GET.value() : OpCode.GETQ.value());
            dst.putShort((short)keyLength);
            dst.put((byte)extrasLength);
            dst.put((byte)0);
            dst.put((byte)0);
            dst.put((byte)0);
            dst.putInt(totalLength);
            dst.putInt(opaque);
            dst.putLong(0L);
            if (hasTTL) {
                dst.putInt(expiration);
            }
            dst.put(key);
        }
        return MultigetRequest.toBuffer(alloc, dst);
    }

    @Override
    public Request<List<GetResult<byte[]>>> duplicate() {
        return new MultigetRequest(this.keys, this.ttl);
    }

    @Override
    public void handle(BinaryResponse replies, HostAndPort server) throws IOException {
        int size = this.keys.size();
        ArrayList<GetResult<byte[]>> result = new ArrayList<GetResult<byte[]>>(size);
        for (int i = 0; i < size; ++i) {
            result.add(null);
        }
        int expectedOpaque = this.opaque;
        for (ResponsePacket reply : replies) {
            if (OpCode.getKind(reply.opcode) != OpCode.GET) {
                throw new IOException("Unmatched response");
            }
            int opaque = reply.opaque & 0xFFFFFF00;
            if (opaque != expectedOpaque) {
                throw new IOException("messages out of order for " + this.getClass().getSimpleName());
            }
            int sequenceCounter = reply.opaque & 0xFF;
            int index = size - sequenceCounter - 1;
            if (index < 0) {
                throw new IOException("Invalid index: " + index);
            }
            if (reply.status == MemcacheStatus.OK) {
                result.set(index, GetResult.success(reply.value, reply.cas, reply.flags));
                continue;
            }
            if (reply.status == MemcacheStatus.KEY_NOT_FOUND) continue;
            throw new IOException("Unexpected response: " + (Object)((Object)reply.status));
        }
        this.succeed(result);
    }

    @Override
    public List<byte[]> getKeys() {
        return this.keys;
    }

    @Override
    public Request<List<GetResult<byte[]>>> create(List<byte[]> keys) {
        return new MultigetRequest(keys, this.ttl);
    }
}

