/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.OpCode;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.binary.BinaryRequest;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SetRequest
extends BinaryRequest<MemcacheStatus>
implements com.spotify.folsom.client.SetRequest {
    private final OpCode opcode;
    private final byte[] value;
    private final int ttl;
    private final long cas;
    private final int flags;

    public SetRequest(OpCode opcode, byte[] key, byte[] value, int ttl, long cas) {
        this(opcode, key, value, ttl, cas, 0);
    }

    public SetRequest(OpCode opcode, byte[] key, byte[] value, int ttl, long cas, int flags) {
        super(key);
        this.opcode = opcode;
        this.value = value;
        this.ttl = ttl;
        this.cas = cas;
        this.flags = flags;
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        int expiration = Utils.ttlToExpiration(this.ttl);
        int valueLength = this.value.length;
        boolean hasExtra = this.opcode == OpCode.SET || this.opcode == OpCode.ADD || this.opcode == OpCode.REPLACE;
        int extraLength = hasExtra ? 8 : 0;
        this.writeHeader(dst, this.opcode, extraLength, valueLength, this.cas);
        if (hasExtra) {
            dst.putInt(this.flags);
            dst.putInt(expiration);
        }
        dst.put(this.key);
        if (dst.remaining() >= valueLength) {
            dst.put(this.value);
            return SetRequest.toBuffer(alloc, dst);
        }
        return SetRequest.toBufferWithValue(alloc, dst, this.value);
    }

    @Override
    public Request<MemcacheStatus> duplicate() {
        return new SetRequest(this.opcode, this.key, this.value, this.ttl, this.cas, this.flags);
    }

    private static ByteBuf toBufferWithValue(ByteBufAllocator alloc, ByteBuffer dst, byte[] value) {
        ByteBuf buffer = SetRequest.toBuffer(alloc, dst, value.length);
        buffer.writeBytes(value);
        return buffer;
    }

    @Override
    public void handle(BinaryResponse replies, HostAndPort server) throws IOException {
        ResponsePacket reply = this.handleSingleReply(replies);
        if (OpCode.getKind(reply.opcode) != OpCode.SET) {
            throw new IOException("Unmatched response");
        }
        MemcacheStatus status = reply.status;
        if (status == MemcacheStatus.KEY_EXISTS && this.opcode == OpCode.ADD) {
            status = MemcacheStatus.ITEM_NOT_STORED;
        } else if (status == MemcacheStatus.KEY_NOT_FOUND && (this.opcode == OpCode.APPEND || this.opcode == OpCode.PREPEND)) {
            status = MemcacheStatus.ITEM_NOT_STORED;
        }
        this.succeed(status);
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }
}

