/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.roundrobin;

import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.client.AbstractMultiMemcacheClient;
import com.spotify.folsom.client.NotConnectedClient;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.guava.HostAndPort;
import com.spotify.folsom.ketama.AddressAndClient;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RoundRobinMemcacheClient
extends AbstractMultiMemcacheClient {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final List<RawMemcacheClient> clients;
    private final int numClients;

    public RoundRobinMemcacheClient(List<RawMemcacheClient> clients) {
        super(clients);
        this.clients = clients;
        this.numClients = clients.size();
    }

    @Override
    public <T> CompletionStage<T> send(Request<T> request) {
        return this.getClient().send(request);
    }

    private RawMemcacheClient getClient() {
        for (int i = 0; i < this.numClients; ++i) {
            int c = this.counter.incrementAndGet() & Integer.MAX_VALUE;
            int index = c % this.numClients;
            RawMemcacheClient client = this.clients.get(index);
            if (!client.isConnected()) continue;
            return client;
        }
        return NotConnectedClient.INSTANCE;
    }

    @Override
    public Stream<AddressAndClient> streamNodes() {
        List childNodes = this.clients.stream().flatMap(RawMemcacheClient::streamNodes).collect(Collectors.toList());
        Set allAddresses = childNodes.stream().map(AddressAndClient::getAddress).collect(Collectors.toSet());
        if (allAddresses.size() == 1) {
            List<RawMemcacheClient> allClients = childNodes.stream().map(AddressAndClient::getClient).collect(Collectors.toList());
            return Stream.of(new AddressAndClient((HostAndPort)allAddresses.iterator().next(), new RoundRobinMemcacheClient(allClients)));
        }
        return childNodes.stream();
    }
}

