/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom;

import com.google.common.annotations.VisibleForTesting;
import com.spotify.folsom.ConnectionChangeListener;
import com.spotify.folsom.RawMemcacheClient;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractRawMemcacheClient
implements RawMemcacheClient {
    private final Set<ConnectionChangeListener> listeners = ConcurrentHashMap.newKeySet();

    @Override
    public void registerForConnectionChanges(ConnectionChangeListener listener) {
        this.listeners.add(listener);
        listener.connectionChanged(this);
    }

    @Override
    public void unregisterForConnectionChanges(ConnectionChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public final void notifyConnectionChange() {
        for (ConnectionChangeListener listener : this.listeners) {
            try {
                listener.connectionChanged(this);
            }
            catch (Exception exception) {}
        }
    }

    @VisibleForTesting
    protected int numListeners() {
        return this.listeners.size();
    }
}

