/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.authenticate;

import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.authenticate.Authenticator;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.ascii.GetRequest;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;

public class AsciiAuthenticationValidator
implements Authenticator {
    private static final AsciiAuthenticationValidator INSTANCE = new AsciiAuthenticationValidator();
    private static final byte[] EXAMPLE_KEY = "folsom_authentication_validation".getBytes(StandardCharsets.US_ASCII);

    public static AsciiAuthenticationValidator getInstance() {
        return INSTANCE;
    }

    private AsciiAuthenticationValidator() {
    }

    @Override
    public CompletionStage<RawMemcacheClient> authenticate(RawMemcacheClient client) {
        GetRequest request = new GetRequest(EXAMPLE_KEY, false);
        return client.connectFuture().thenCompose(ignored -> client.send(request).handle((status, throwable) -> {
            if (throwable == null) {
                return client;
            }
            throw new CompletionException(Utils.unwrap(throwable));
        }));
    }

    @Override
    public void validate(boolean binary) {
        if (binary) {
            throw new IllegalStateException("Programmer error: wrong validator used");
        }
    }
}

