/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client;

import java.util.concurrent.TimeUnit;

class TimeoutChecker<T> {
    private final long timeoutNanos;
    private T pending;
    private long timestamp;

    public TimeoutChecker(TimeUnit unit, long timeout) {
        this.timeoutNanos = unit.toNanos(timeout);
    }

    public boolean check(T current) {
        long nowNanos = System.nanoTime();
        if (current != this.pending) {
            this.pending = current;
            this.timestamp = nowNanos;
            return false;
        }
        return nowNanos - this.timestamp > this.timeoutNanos;
    }

    public static <T> TimeoutChecker<T> create(TimeUnit unit, long timeout) {
        return new TimeoutChecker<T>(unit, timeout);
    }
}

