/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.google.common.collect.ImmutableMap;
import com.spotify.folsom.MemcachedStats;
import com.spotify.folsom.client.AllRequest;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.ascii.AsciiRequest;
import com.spotify.folsom.client.ascii.AsciiResponse;
import com.spotify.folsom.client.ascii.StatsAsciiResponse;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class StatsRequest
extends AsciiRequest<Map<String, MemcachedStats>>
implements AllRequest<Map<String, MemcachedStats>> {
    private static final byte[] CMD = "stats ".getBytes();

    public StatsRequest(String key) {
        this(key.getBytes(StandardCharsets.US_ASCII));
    }

    private StatsRequest(byte[] key) {
        super(key);
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        dst.put(CMD);
        dst.put(this.key);
        dst.put(NEWLINE_BYTES);
        return StatsRequest.toBuffer(alloc, dst);
    }

    @Override
    protected void handle(AsciiResponse response, HostAndPort server) throws IOException {
        AsciiResponse.Type type = response.type;
        String host = server.getHostText() + ":" + server.getPort();
        if (type == AsciiResponse.Type.STATS) {
            StatsAsciiResponse statsResponse = (StatsAsciiResponse)response;
            this.succeed(ImmutableMap.of((Object)host, (Object)new MemcachedStats(statsResponse.values)));
        } else if (type == AsciiResponse.Type.ERROR) {
            this.succeed(ImmutableMap.of((Object)host, (Object)new MemcachedStats((Map<String, String>)ImmutableMap.of())));
        } else {
            throw new IOException("Unexpected response type: " + (Object)((Object)type));
        }
    }

    @Override
    public Map<String, MemcachedStats> merge(List<Map<String, MemcachedStats>> results) {
        return AllRequest.mergeStats(results);
    }

    @Override
    public Request<Map<String, MemcachedStats>> duplicate() {
        return new StatsRequest(this.key);
    }
}

