/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.spotify.folsom.GetResult;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.OpCode;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.binary.BinaryRequest;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class GetRequest
extends BinaryRequest<GetResult<byte[]>>
implements com.spotify.folsom.client.GetRequest {
    private final OpCode opcode;
    private final int ttl;

    public GetRequest(byte[] key, OpCode opcode, int ttl) {
        super(key);
        this.opcode = Objects.requireNonNull(opcode, "opcode");
        this.ttl = Objects.requireNonNull(Integer.valueOf(ttl), "ttl");
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        int extrasLength;
        int expiration;
        if (this.ttl > 0) {
            expiration = Utils.ttlToExpiration(this.ttl);
            extrasLength = 4;
        } else {
            expiration = 0;
            extrasLength = 0;
        }
        this.writeHeader(dst, this.opcode, extrasLength, 0, 0L);
        if (this.ttl > 0) {
            dst.putInt(expiration);
        }
        dst.put(this.key);
        return GetRequest.toBuffer(alloc, dst);
    }

    @Override
    public Request<GetResult<byte[]>> duplicate() {
        return new GetRequest(this.key, this.opcode, this.ttl);
    }

    @Override
    public void handle(BinaryResponse replies, HostAndPort server) throws IOException {
        ResponsePacket reply = this.handleSingleReply(replies);
        if (OpCode.getKind(reply.opcode) != OpCode.GET) {
            throw new IOException("Unmatched response");
        }
        if (reply.status == MemcacheStatus.OK) {
            this.succeed(GetResult.success(reply.value, reply.cas, reply.flags));
        } else if (reply.status == MemcacheStatus.KEY_NOT_FOUND) {
            this.succeed(null);
        } else {
            throw new IOException("Unexpected response: " + (Object)((Object)reply.status));
        }
    }
}

