/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom;

import com.spotify.folsom.GetResult;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.MemcachedStats;
import com.spotify.folsom.ObservableClient;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.client.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public interface MemcacheClient<V>
extends ObservableClient {
    public CompletionStage<MemcacheStatus> set(String var1, V var2, int var3);

    default public CompletionStage<MemcacheStatus> set(String key, V value, int ttl, int flags) {
        return this.set(key, value, ttl);
    }

    public CompletionStage<MemcacheStatus> set(String var1, V var2, int var3, long var4);

    default public CompletionStage<MemcacheStatus> set(String key, V value, int ttl, long cas, int flags) {
        return this.set(key, value, ttl, cas);
    }

    public CompletionStage<MemcacheStatus> delete(String var1);

    public CompletionStage<MemcacheStatus> delete(String var1, long var2);

    public CompletionStage<MemcacheStatus> deleteAll(String var1);

    public CompletionStage<MemcacheStatus> add(String var1, V var2, int var3);

    default public CompletionStage<MemcacheStatus> add(String key, V value, int ttl, int flags) {
        return this.add(key, value, ttl);
    }

    public CompletionStage<MemcacheStatus> replace(String var1, V var2, int var3);

    default public CompletionStage<MemcacheStatus> replace(String key, V value, int ttl, int flags) {
        return this.replace(key, value, ttl, flags);
    }

    public CompletionStage<MemcacheStatus> append(String var1, V var2);

    public CompletionStage<MemcacheStatus> prepend(String var1, V var2);

    public CompletionStage<V> get(String var1);

    public CompletionStage<GetResult<V>> casGet(String var1);

    public CompletionStage<List<V>> get(List<String> var1);

    default public CompletionStage<Map<String, V>> getAsMap(List<String> keys) {
        return this.get(keys).thenApply(values -> Utils.zipToMap(keys, values));
    }

    public CompletionStage<List<GetResult<V>>> casGet(List<String> var1);

    default public CompletionStage<Map<String, GetResult<V>>> casGetAsMap(List<String> keys) {
        return this.casGet(keys).thenApply(values -> Utils.zipToMap(keys, values));
    }

    public CompletionStage<MemcacheStatus> touch(String var1, int var2);

    public CompletionStage<MemcacheStatus> flushAll(int var1);

    public CompletionStage<Map<String, MemcachedStats>> getStats(String var1);

    public void shutdown();

    public RawMemcacheClient getRawMemcacheClient();

    default public Map<String, ? extends MemcacheClient<V>> getAllNodes() {
        return Collections.emptyMap();
    }
}

