/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom;

import com.spotify.folsom.ConnectFuture;
import com.spotify.folsom.ConnectionChangeListener;
import com.spotify.folsom.MemcacheAuthenticationException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public interface ObservableClient {
    public void registerForConnectionChanges(ConnectionChangeListener var1);

    public void unregisterForConnectionChanges(ConnectionChangeListener var1);

    public boolean isConnected();

    default public CompletionStage<Void> connectFuture() {
        return ConnectFuture.connectFuture(this);
    }

    default public CompletionStage<Void> disconnectFuture() {
        return ConnectFuture.disconnectFuture(this);
    }

    default public CompletionStage<Void> fullyConnectedFuture() {
        return ConnectFuture.fullyConnectedFuture(this);
    }

    default public CompletionStage<Void> fullyDisconnectFuture() {
        return ConnectFuture.fullyDisconnectedFuture(this);
    }

    default public void awaitConnected(long waitTime, TimeUnit unit) throws TimeoutException, InterruptedException {
        this.awaitFuture(this.connectFuture(), waitTime, unit);
    }

    default public void awaitDisconnected(long waitTime, TimeUnit unit) throws TimeoutException, InterruptedException {
        this.awaitFuture(this.disconnectFuture(), waitTime, unit);
    }

    default public void awaitFullyConnected(long waitTime, TimeUnit unit) throws TimeoutException, InterruptedException {
        this.awaitFuture(this.fullyConnectedFuture(), waitTime, unit);
    }

    default public void awaitFullyDisconnected(long waitTime, TimeUnit unit) throws TimeoutException, InterruptedException {
        this.awaitFuture(this.fullyDisconnectFuture(), waitTime, unit);
    }

    default public void awaitFuture(CompletionStage<Void> future, long waitTime, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            future.toCompletableFuture().get(waitTime, unit);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof MemcacheAuthenticationException) {
                throw (MemcacheAuthenticationException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public Throwable getConnectionFailure();

    public int numTotalConnections();

    public int numActiveConnections();

    default public void notifyConnectionChange() {
    }
}

