/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

public interface Resolver {
    public List<ResolveResult> resolve();

    public static class ResolveResult {
        private final String host;
        private final int port;
        private final long ttl;

        public ResolveResult(String host, int port, long ttl) {
            this.host = Objects.requireNonNull(host);
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"port must be a positive integer");
            this.port = port;
            Preconditions.checkArgument((ttl > 0L ? 1 : 0) != 0, (Object)"ttl must be a positive integer");
            this.ttl = ttl;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public long getTtl() {
            return this.ttl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolveResult that = (ResolveResult)o;
            return this.port == that.port && this.ttl == that.ttl && Objects.equals(this.host, that.host);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port, this.ttl);
        }

        public String toString() {
            return "ResolveResult{host='" + this.host + "', port=" + this.port + ", ttl=" + this.ttl + '}';
        }
    }
}

