/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.spotify.dns.DnsSrvResolver;
import com.spotify.dns.DnsSrvResolvers;
import com.spotify.folsom.Resolver;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SrvResolver
implements Resolver {
    private static final java.util.function.Supplier<DnsSrvResolver> DEFAULT_DNS_RESOLVER = () -> ((Supplier)Suppliers.memoize(() -> DnsSrvResolvers.newBuilder().cachingLookups(true).retainingDataOnFailures(true).build())).get();
    private final DnsSrvResolver dnsSrvResolver;
    private final String srvRecord;

    public static Builder newBuilder(String srvRecord) {
        return new Builder(srvRecord);
    }

    private SrvResolver(DnsSrvResolver dnsSrvResolver, String srvRecord) {
        this.dnsSrvResolver = dnsSrvResolver;
        this.srvRecord = srvRecord;
    }

    @Override
    public List<Resolver.ResolveResult> resolve() {
        return this.dnsSrvResolver.resolve(this.srvRecord).stream().map(result -> new Resolver.ResolveResult(result.host(), result.port(), result.ttl())).collect(Collectors.toList());
    }

    public static class Builder {
        private final String srvRecord;
        private DnsSrvResolver srvResolver;

        private Builder(String srvRecord) {
            this.srvRecord = Objects.requireNonNull(srvRecord, "srvRecord");
        }

        public Builder withSrvResolver(DnsSrvResolver srvResolver) {
            this.srvResolver = Objects.requireNonNull(srvResolver, "srvResolver");
            return this;
        }

        public SrvResolver build() {
            DnsSrvResolver srvResolver = this.srvResolver;
            if (srvResolver == null) {
                srvResolver = (DnsSrvResolver)DEFAULT_DNS_RESOLVER.get();
            }
            return new SrvResolver(srvResolver, this.srvRecord);
        }
    }
}

