/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.authenticate;

import com.spotify.folsom.MemcacheAuthenticationException;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.authenticate.Authenticator;
import com.spotify.folsom.client.binary.PlaintextAuthenticateRequest;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

public class PlaintextAuthenticator
implements Authenticator {
    private final String username;
    private final String password;

    public PlaintextAuthenticator(String username, String password) {
        this.username = Objects.requireNonNull(username);
        this.password = Objects.requireNonNull(password);
    }

    @Override
    public CompletionStage<RawMemcacheClient> authenticate(RawMemcacheClient client) {
        PlaintextAuthenticateRequest authenticateRequest = new PlaintextAuthenticateRequest(this.username, this.password);
        return client.connectFuture().thenCompose(ignored -> client.send(authenticateRequest).thenApply(status -> {
            if (status == MemcacheStatus.OK) {
                return client;
            }
            if (status == MemcacheStatus.UNAUTHORIZED) {
                throw new MemcacheAuthenticationException("Authentication failed");
            }
            throw new RuntimeException("Unexpected status: " + status.name());
        }));
    }

    @Override
    public void validate(boolean binary) {
        if (!binary) {
            throw new IllegalArgumentException("Authentication can only be used for binary clients.");
        }
    }
}

