/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.reconnect;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.spotify.folsom.AbstractRawMemcacheClient;
import com.spotify.folsom.BackoffFunction;
import com.spotify.folsom.MemcacheAuthenticationException;
import com.spotify.folsom.Metrics;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.authenticate.AuthenticatingClient;
import com.spotify.folsom.authenticate.Authenticator;
import com.spotify.folsom.client.DefaultRawMemcacheClient;
import com.spotify.folsom.client.NotConnectedClient;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.guava.HostAndPort;
import com.spotify.folsom.ketama.AddressAndClient;
import com.spotify.folsom.reconnect.Connector;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import java.nio.charset.Charset;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectingClient
extends AbstractRawMemcacheClient {
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("folsom-reconnecter").build());
    private final Logger log = LoggerFactory.getLogger(ReconnectingClient.class);
    private final BackoffFunction backoffFunction;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Connector connector;
    private final HostAndPort address;
    private volatile RawMemcacheClient client = NotConnectedClient.INSTANCE;
    private volatile int reconnectCount = 0;
    private volatile boolean stayConnected = true;
    private volatile Throwable connectionFailure;

    public ReconnectingClient(BackoffFunction backoffFunction, ScheduledExecutorService scheduledExecutorService, HostAndPort address, int outstandingRequestLimit, int eventLoopThreadFlushMaxBatchSize, boolean binary, Authenticator authenticator, Executor executor, long connectionTimeoutMillis, Charset charset, Metrics metrics, int maxSetLength, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) {
        this(backoffFunction, scheduledExecutorService, () -> DefaultRawMemcacheClient.connect(address, outstandingRequestLimit, eventLoopThreadFlushMaxBatchSize, binary, executor, connectionTimeoutMillis, charset, metrics, maxSetLength, eventLoopGroup, channelClass), authenticator, address);
    }

    private ReconnectingClient(BackoffFunction backoffFunction, ScheduledExecutorService scheduledExecutorService, Connector connector, Authenticator authenticator, HostAndPort address) {
        this(backoffFunction, scheduledExecutorService, () -> AuthenticatingClient.authenticate(connector, authenticator), address);
    }

    ReconnectingClient(BackoffFunction backoffFunction, ScheduledExecutorService scheduledExecutorService, Connector connector, HostAndPort address) {
        this.backoffFunction = backoffFunction;
        this.scheduledExecutorService = scheduledExecutorService;
        this.connector = connector;
        this.address = address;
        this.retry();
    }

    @Override
    public <T> CompletionStage<T> send(Request<T> request) {
        return this.client.send(request);
    }

    @Override
    public void shutdown() {
        this.stayConnected = false;
        this.client.shutdown();
        this.notifyConnectionChange();
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public Throwable getConnectionFailure() {
        return this.connectionFailure;
    }

    @Override
    public int numTotalConnections() {
        return this.client.numTotalConnections();
    }

    @Override
    public int numActiveConnections() {
        return this.client.numActiveConnections();
    }

    @Override
    public int numPendingRequests() {
        return this.client.numPendingRequests();
    }

    @Override
    public Stream<AddressAndClient> streamNodes() {
        return this.client.streamNodes();
    }

    private void retry() {
        try {
            CompletionStage<RawMemcacheClient> future = this.connector.connect();
            future.whenComplete((newClient, t) -> {
                if (t != null) {
                    if (t instanceof CompletionException && t.getCause() instanceof MemcacheAuthenticationException) {
                        this.connectionFailure = t.getCause();
                        this.shutdown();
                        return;
                    }
                    this.onFailure();
                } else {
                    this.log.info("Successfully connected to {}", (Object)this.address);
                    this.reconnectCount = 0;
                    this.client.shutdown();
                    this.client = newClient;
                    if (!this.stayConnected) {
                        newClient.shutdown();
                        this.notifyConnectionChange();
                        return;
                    }
                    this.notifyConnectionChange();
                    newClient.disconnectFuture().thenRun(() -> {
                        this.log.info("Lost connection to {}", (Object)this.address);
                        this.notifyConnectionChange();
                        if (this.stayConnected) {
                            this.retry();
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            this.onFailure();
        }
    }

    private void onFailure() {
        if (!this.stayConnected) {
            return;
        }
        long backOff = this.backoffFunction.getBackoffTimeMillis(this.reconnectCount);
        this.log.warn("Attempting reconnect to {} in {} ms (retry number {})", new Object[]{this.address, backOff, this.reconnectCount});
        ++this.reconnectCount;
        this.scheduledExecutorService.schedule(() -> {
            if (this.stayConnected) {
                this.retry();
            }
        }, backOff, TimeUnit.MILLISECONDS);
    }

    public static ScheduledExecutorService singletonExecutor() {
        return SCHEDULED_EXECUTOR_SERVICE;
    }

    public String toString() {
        return "Reconnecting(" + this.client + ")";
    }
}

