/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.ascii.AsciiResponse;
import com.spotify.folsom.client.ascii.SetRequest;
import com.spotify.folsom.guava.HostAndPort;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class AsciiAuthenticateRequest
extends SetRequest {
    private static final byte[] KEY = "ASCII_AUTH".getBytes(StandardCharsets.US_ASCII);

    public AsciiAuthenticateRequest(String username, String password) {
        super(SetRequest.Operation.SET, KEY, (username + " " + password).getBytes(StandardCharsets.US_ASCII), 0, 0L, 0);
    }

    @Override
    public void handle(AsciiResponse response, HostAndPort server) throws IOException {
        switch (response.type) {
            case STORED: {
                this.succeed(MemcacheStatus.OK);
                return;
            }
            case CLIENT_ERROR: {
                this.succeed(MemcacheStatus.UNAUTHORIZED);
                return;
            }
        }
        IOException exception = new IOException(String.format("Invalid response %s, expected STORED or CLIENT_ERROR.", new Object[]{response.type}));
        this.fail(exception, server);
    }
}

