/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.spotify.folsom.MemcacheAuthenticationException;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.ascii.AsciiRequest;
import com.spotify.folsom.client.ascii.AsciiResponse;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class DeleteWithCasRequest
extends AsciiRequest<MemcacheStatus> {
    private static final byte[] CMD_BYTES = "cas ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] FLAGS_EXPTIME_LENGTH_BYTES = " 0 -1 1 ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] VALUE_BYTES = "\r\na\r\n".getBytes(StandardCharsets.US_ASCII);
    private final long cas;

    public DeleteWithCasRequest(byte[] key, long cas) {
        super(key);
        this.cas = cas;
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        dst.put(CMD_BYTES);
        dst.put(this.key);
        dst.put(FLAGS_EXPTIME_LENGTH_BYTES);
        dst.put(String.valueOf(this.cas).getBytes());
        dst.put(VALUE_BYTES);
        return DeleteWithCasRequest.toBuffer(alloc, dst);
    }

    @Override
    public Request<MemcacheStatus> duplicate() {
        return new DeleteWithCasRequest(this.key, this.cas);
    }

    @Override
    public void handle(AsciiResponse response, HostAndPort server) throws IOException {
        switch (response.type) {
            case STORED: {
                this.succeed(MemcacheStatus.OK);
                return;
            }
            case EXISTS: {
                this.succeed(MemcacheStatus.KEY_EXISTS);
                return;
            }
            case NOT_FOUND: {
                this.succeed(MemcacheStatus.KEY_NOT_FOUND);
                return;
            }
            case CLIENT_ERROR: {
                MemcacheAuthenticationException exception = new MemcacheAuthenticationException("Authentication required by server. Client not authenticated.");
                this.fail(exception, server);
                return;
            }
        }
        throw new IOException("Unexpected line: " + (Object)((Object)response.type));
    }
}

