/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.spotify.folsom.MemcacheAuthenticationException;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.OpCode;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.binary.BinaryRequest;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class NoopRequest
extends BinaryRequest<Void> {
    private static final byte[] DUMMY_KEY = "X".getBytes(StandardCharsets.US_ASCII);

    public NoopRequest() {
        super(DUMMY_KEY);
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        dst.put((byte)-128);
        dst.put(OpCode.NOOP.value());
        dst.putShort((short)0);
        dst.put((byte)0);
        dst.put((byte)0);
        dst.put((byte)0);
        dst.put((byte)0);
        dst.putInt(0);
        dst.putInt(this.opaque);
        dst.putLong(0L);
        return NoopRequest.toBuffer(alloc, dst);
    }

    @Override
    public Request<Void> duplicate() {
        return new NoopRequest();
    }

    @Override
    public void handle(BinaryResponse replies, HostAndPort server) throws IOException {
        ResponsePacket reply = this.handleSingleReply(replies);
        if (reply.status == MemcacheStatus.OK) {
            this.succeed(null);
        } else if (reply.status == MemcacheStatus.UNAUTHORIZED) {
            this.fail(new MemcacheAuthenticationException("Authentication required"), server);
        } else {
            throw new IOException("Unexpected response: " + (Object)((Object)reply.status));
        }
    }
}

