/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom;

import com.spotify.folsom.ConnectionChangeListener;
import com.spotify.folsom.ObservableClient;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class ConnectFuture
extends CompletableFuture<Void>
implements ConnectionChangeListener {
    private final boolean awaitConnected;
    private final boolean requireAll;

    private ConnectFuture(ObservableClient client, boolean awaitConnected, boolean requireAll) {
        this.awaitConnected = awaitConnected;
        this.requireAll = requireAll;
        client.registerForConnectionChanges(this);
        this.check(client);
    }

    public static CompletionStage<Void> disconnectFuture(ObservableClient client) {
        return new ConnectFuture(client, false, false);
    }

    public static CompletionStage<Void> fullyDisconnectedFuture(ObservableClient client) {
        return new ConnectFuture(client, false, true);
    }

    public static CompletionStage<Void> connectFuture(ObservableClient client) {
        return new ConnectFuture(client, true, false);
    }

    public static CompletionStage<Void> fullyConnectedFuture(ObservableClient client) {
        return new ConnectFuture(client, true, true);
    }

    @Override
    public void connectionChanged(ObservableClient client) {
        this.check(client);
    }

    private void check(ObservableClient client) {
        Throwable failure = client.getConnectionFailure();
        if (failure != null) {
            if (this.completeExceptionally(failure)) {
                client.unregisterForConnectionChanges(this);
            }
        } else if (this.requireAll) {
            int expectedConnections;
            int n = expectedConnections = this.awaitConnected ? client.numTotalConnections() : 0;
            if (client.numActiveConnections() == expectedConnections && this.complete(null)) {
                client.unregisterForConnectionChanges(this);
            }
        } else if (this.awaitConnected == client.isConnected() && this.complete(null)) {
            client.unregisterForConnectionChanges(this);
        }
    }
}

