/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom;

import com.spotify.folsom.BackoffFunction;

public class ExponentialBackoff
implements BackoffFunction {
    private final long minTime;
    private final long maxTime;
    private final double factor;

    public ExponentialBackoff(long minTime, long maxTime, double factor) {
        this.minTime = minTime;
        this.maxTime = maxTime;
        this.factor = factor;
    }

    @Override
    public long getBackoffTimeMillis(int reconnectAttempt) {
        if (reconnectAttempt <= 0) {
            return 0L;
        }
        return (long)Math.min((double)this.maxTime, (double)this.minTime * Math.pow(this.factor, reconnectAttempt - 1));
    }
}

