/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client;

import com.spotify.folsom.GetResult;
import com.spotify.folsom.Transcoder;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TransformerUtil<T> {
    private final Function<GetResult<T>, T> getResultToValue = new ResultUnwrapper();
    private final ListResultUnwrapper<T> listResultUnwrapper = new ListResultUnwrapper<T>(this.getResultToValue);
    private final ResultDecoder<T> resultDecoder;
    private final ListResultDecoder<T> listResultDecoder;

    public TransformerUtil(Transcoder<T> transcoder) {
        this.resultDecoder = new ResultDecoder<T>(transcoder);
        this.listResultDecoder = new ListResultDecoder<T>(this.resultDecoder);
    }

    public CompletionStage<T> unwrap(CompletionStage<GetResult<T>> future) {
        return future.thenApply(this.getResultToValue);
    }

    public CompletionStage<GetResult<T>> decode(CompletionStage<GetResult<byte[]>> future) {
        return future.thenApply(this.resultDecoder);
    }

    public CompletionStage<List<T>> unwrapList(CompletionStage<List<GetResult<T>>> future) {
        return future.thenApply(this.listResultUnwrapper);
    }

    public CompletionStage<List<GetResult<T>>> decodeList(CompletionStage<List<GetResult<byte[]>>> future) {
        return future.thenApply(this.listResultDecoder);
    }

    private static class ListResultDecoder<T>
    implements Function<List<GetResult<byte[]>>, List<GetResult<T>>> {
        private final ResultDecoder<T> resultDecoder;

        public ListResultDecoder(ResultDecoder<T> resultDecoder) {
            this.resultDecoder = resultDecoder;
        }

        @Override
        public List<GetResult<T>> apply(List<GetResult<byte[]>> input) {
            return input.stream().map(this.resultDecoder).collect(Collectors.toList());
        }
    }

    private static class ResultDecoder<T>
    implements Function<GetResult<byte[]>, GetResult<T>> {
        private final Transcoder<T> transcoder;

        public ResultDecoder(Transcoder<T> transcoder) {
            this.transcoder = transcoder;
        }

        @Override
        public GetResult<T> apply(GetResult<byte[]> input) {
            if (input == null) {
                return null;
            }
            return GetResult.success(this.transcoder.decode(input.getValue()), input.getCas(), input.getFlags());
        }
    }

    private static class ListResultUnwrapper<T>
    implements Function<List<GetResult<T>>, List<T>> {
        private final Function<GetResult<T>, T> resultUnwrapper;

        public ListResultUnwrapper(Function<GetResult<T>, T> resultUnwrapper) {
            this.resultUnwrapper = resultUnwrapper;
        }

        @Override
        public List<T> apply(List<GetResult<T>> input) {
            return input.stream().map(this.resultUnwrapper).collect(Collectors.toList());
        }
    }

    private static class ResultUnwrapper<T>
    implements Function<GetResult<T>, T> {
        private ResultUnwrapper() {
        }

        @Override
        public T apply(GetResult<T> input) {
            if (input == null) {
                return null;
            }
            return input.getValue();
        }
    }
}

