/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.OpCode;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.binary.BinaryRequest;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class PlaintextAuthenticateRequest
extends BinaryRequest<MemcacheStatus> {
    private static final byte[] KEY = "PLAIN".getBytes(StandardCharsets.US_ASCII);
    private final String username;
    private final String password;

    public PlaintextAuthenticateRequest(String username, String password) {
        super(KEY);
        this.username = Objects.requireNonNull(username);
        this.password = Objects.requireNonNull(password);
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        int valueLength = 2 + this.username.length() + this.password.length();
        this.writeHeader(dst, OpCode.SASL_AUTH, 0, valueLength, 0L);
        dst.put(this.key);
        boolean separator = false;
        dst.put((byte)0);
        dst.put(this.username.getBytes(StandardCharsets.US_ASCII));
        dst.put((byte)0);
        dst.put(this.password.getBytes(StandardCharsets.US_ASCII));
        return PlaintextAuthenticateRequest.toBuffer(alloc, dst);
    }

    @Override
    public Request<MemcacheStatus> duplicate() {
        return new PlaintextAuthenticateRequest(this.username, this.password);
    }

    @Override
    protected void handle(BinaryResponse replies, HostAndPort server) throws IOException {
        ResponsePacket reply = this.handleSingleReply(replies);
        if (OpCode.getKind(reply.opcode) != OpCode.SASL_AUTH) {
            throw new IOException("Unmatched response");
        }
        MemcacheStatus status = reply.status;
        if (status == MemcacheStatus.UNKNOWN_COMMAND) {
            this.succeed(MemcacheStatus.OK);
        } else if (status == MemcacheStatus.OK || status == MemcacheStatus.UNAUTHORIZED) {
            this.succeed(status);
        } else {
            IOException exception = new IOException(String.format("Invalid status %s, expected OK or UNAUTHORIZED.", status.toString()));
            this.fail(exception, server);
        }
    }
}

