/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.tls;

import com.spotify.folsom.client.tls.SSLEngineFactory;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class DefaultSSLEngineFactory
implements SSLEngineFactory {
    private final SSLContext sslContext;
    private final boolean reuseSession;

    public DefaultSSLEngineFactory(boolean reuseSession) throws NoSuchAlgorithmException {
        this(SSLContext.getDefault(), reuseSession);
    }

    public DefaultSSLEngineFactory(SSLContext sslContext, boolean reuseSession) {
        this.sslContext = sslContext;
        this.reuseSession = reuseSession;
    }

    @Override
    public SSLEngine createSSLEngine(String hostname, int port) {
        SSLEngine sslEngine = this.reuseSession ? this.sslContext.createSSLEngine(hostname, port) : this.sslContext.createSSLEngine();
        sslEngine.setUseClientMode(true);
        return sslEngine;
    }
}

