/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.ketama;

import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.client.AbstractMultiMemcacheClient;
import com.spotify.folsom.client.AllRequest;
import com.spotify.folsom.client.MultiRequest;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.ketama.AddressAndClient;
import com.spotify.folsom.ketama.NodeLocator;
import com.spotify.futures.CompletableFutures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;

public class KetamaMemcacheClient
extends AbstractMultiMemcacheClient {
    private final NodeLocator nodeLocator;

    private static Collection<RawMemcacheClient> clientsOnly(Collection<AddressAndClient> addressAndClients) {
        int size = addressAndClients.size();
        ArrayList<RawMemcacheClient> clients = new ArrayList<RawMemcacheClient>(size);
        for (AddressAndClient client : addressAndClients) {
            clients.add(client.getClient());
        }
        return clients;
    }

    public KetamaMemcacheClient(Collection<AddressAndClient> clients, NodeLocator nodeLocator) {
        super(KetamaMemcacheClient.clientsOnly(clients));
        if (clients.isEmpty()) {
            throw new IllegalArgumentException("Can not create ketama client from empty list");
        }
        this.nodeLocator = nodeLocator;
    }

    private RawMemcacheClient getClient(byte[] key) {
        return this.nodeLocator.findClient(key);
    }

    @Override
    public <T> CompletionStage<T> send(Request<T> request) {
        if (request instanceof MultiRequest) {
            MultiRequest multiRequest = (MultiRequest)((Object)request);
            if (multiRequest.getKeys().size() > 1) {
                return this.sendSplitRequest(multiRequest);
            }
        } else if (request instanceof AllRequest) {
            return this.sendToAll((AllRequest)request);
        }
        return this.getClient(request.getKey()).send(request);
    }

    private <T> CompletionStage<T> sendToAll(AllRequest<T> request) {
        List futures = this.clients.stream().map(client -> client.send(request.duplicate())).map(request::preMerge).collect(Collectors.toList());
        return CompletableFutures.allAsList(futures).thenApply(request::merge);
    }

    private <T> CompletionStage<List<T>> sendSplitRequest(MultiRequest<T> multiRequest) {
        List subKeys;
        List<byte[]> keys = multiRequest.getKeys();
        IdentityHashMap<RawMemcacheClient, List> routing = new IdentityHashMap<RawMemcacheClient, List>();
        ArrayList<RawMemcacheClient> routing2 = new ArrayList<RawMemcacheClient>(keys.size());
        for (byte[] byArray : keys) {
            RawMemcacheClient client = this.getClient(byArray);
            subKeys = routing.computeIfAbsent(client, k -> new ArrayList());
            subKeys.add(byArray);
            routing2.add(client);
        }
        IdentityHashMap<RawMemcacheClient, CompletionStage<List<T>>> futures = new IdentityHashMap<RawMemcacheClient, CompletionStage<List<T>>>();
        for (Map.Entry entry : routing.entrySet()) {
            subKeys = (List)entry.getValue();
            Request<List<T>> subRequest = multiRequest.create(subKeys);
            RawMemcacheClient client = (RawMemcacheClient)entry.getKey();
            CompletionStage<List<T>> send = client.send(subRequest);
            futures.put(client, send);
        }
        Collection collection = futures.values();
        return CompletableFuture.allOf(collection.toArray(new CompletableFuture[collection.size()])).thenApply((Function)new Assembler(futures, routing2));
    }

    private static class Assembler<T, R>
    implements Function<Void, List<T>> {
        private final Map<R, CompletionStage<List<T>>> futures;
        private final List<R> routing2;

        public Assembler(Map<R, CompletionStage<List<T>>> futures, List<R> routing2) {
            this.futures = futures;
            this.routing2 = routing2;
        }

        @Override
        public List<T> apply(Void ignored) {
            IdentityHashMap map = new IdentityHashMap();
            for (Map.Entry<R, CompletionStage<List<T>>> entry : this.futures.entrySet()) {
                R client = entry.getKey();
                map.put(client, ((List)CompletableFutures.getCompleted(entry.getValue())).iterator());
            }
            ArrayList result = new ArrayList();
            for (R memcacheClient : this.routing2) {
                Iterator iterator = (Iterator)map.get(memcacheClient);
                result.add(iterator.next());
            }
            return result;
        }
    }
}

