/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.futures;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class AsyncRetrier {
    public static final long DEFAULT_DELAY_MILLIS = 0L;
    private final ScheduledExecutorService executorService;

    private AsyncRetrier(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    public static AsyncRetrier create(ScheduledExecutorService sleeper) {
        return new AsyncRetrier(sleeper);
    }

    public <T> ListenableFuture<T> retry(Supplier<ListenableFuture<T>> code, int retries) {
        return this.retry(code, retries, 0L, TimeUnit.MILLISECONDS, Predicates.alwaysTrue());
    }

    public <T> ListenableFuture<T> retry(Supplier<ListenableFuture<T>> code, int retries, long delayMillis) {
        return this.retry(code, retries, delayMillis, TimeUnit.MILLISECONDS, Predicates.alwaysTrue());
    }

    public <T> ListenableFuture<T> retry(Supplier<ListenableFuture<T>> code, int retries, long delay, TimeUnit timeUnit) {
        return this.retry(code, retries, delay, timeUnit, Predicates.alwaysTrue());
    }

    public <T> ListenableFuture<T> retry(Supplier<ListenableFuture<T>> code, int retries, long delay, TimeUnit timeUnit, Predicate<T> retryCondition) {
        SettableFuture future = SettableFuture.create();
        this.startRetry(future, code, retries, delay, timeUnit, retryCondition);
        return future;
    }

    private <T> void startRetry(final SettableFuture<T> future, final Supplier<ListenableFuture<T>> code, final int retries, final long delay, final TimeUnit timeUnit, final Predicate<T> retryCondition) {
        ListenableFuture codeFuture;
        try {
            codeFuture = (ListenableFuture)code.get();
        }
        catch (Exception e) {
            this.handleFailure(future, code, retries, delay, timeUnit, retryCondition, e);
            return;
        }
        Futures.addCallback((ListenableFuture)codeFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                if (retryCondition.apply(result)) {
                    future.set(result);
                } else {
                    RuntimeException exception = new RuntimeException("Failed retry condition");
                    AsyncRetrier.this.handleFailure(future, code, retries, delay, timeUnit, retryCondition, exception);
                }
            }

            public void onFailure(Throwable t) {
                AsyncRetrier.this.handleFailure(future, code, retries, delay, timeUnit, retryCondition, t);
            }
        });
    }

    private <T> void handleFailure(final SettableFuture<T> future, final Supplier<ListenableFuture<T>> code, final int retries, final long delay, final TimeUnit timeUnit, final Predicate<T> retryCondition, Throwable t) {
        if (retries > 0) {
            if (delay > 0L) {
                this.executorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        AsyncRetrier.this.startRetry(future, code, retries - 1, delay, timeUnit, retryCondition);
                    }
                }, delay, timeUnit);
            } else {
                this.startRetry(future, code, retries - 1, delay, timeUnit, retryCondition);
            }
        } else {
            future.setException(t);
        }
    }
}

