/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.futures;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.futures.CompletableToListenableFutureWrapper;
import com.spotify.futures.ListenableToCompletableFutureWrapper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CompletableFuturesExtra {
    private CompletableFuturesExtra() {
        throw new AssertionError();
    }

    public static <V> CompletableFuture<V> toCompletableFuture(ListenableFuture<V> future) {
        if (future instanceof CompletableToListenableFutureWrapper) {
            return ((CompletableToListenableFutureWrapper)future).unwrap();
        }
        return new ListenableToCompletableFutureWrapper<V>(future);
    }

    public static <V> ListenableFuture<V> toListenableFuture(CompletableFuture<V> future) {
        return CompletableFuturesExtra.toListenableFuture(future);
    }

    public static <V> ListenableFuture<V> toListenableFuture(CompletionStage<V> future) {
        if (future instanceof ListenableToCompletableFutureWrapper) {
            return ((ListenableToCompletableFutureWrapper)future).unwrap();
        }
        return new CompletableToListenableFutureWrapper<V>(future);
    }

    public static <T> CompletableFuture<T> exceptionallyCompletedFuture(Throwable throwable) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(throwable);
        return future;
    }

    public static <T, U> CompletionStage<U> handleCompose(CompletionStage<T> stage, BiFunction<? super T, Throwable, ? extends CompletionStage<U>> fn) {
        return CompletableFuturesExtra.dereference(stage.handle(fn));
    }

    public static <T> CompletionStage<T> exceptionallyCompose(CompletionStage<T> stage, Function<Throwable, ? extends CompletionStage<T>> fn) {
        return CompletableFuturesExtra.dereference(CompletableFuturesExtra.wrap(stage).exceptionally(fn));
    }

    public static <T> void checkCompleted(CompletionStage<T> stage) {
        if (!stage.toCompletableFuture().isDone()) {
            throw new IllegalStateException("future was not completed");
        }
    }

    public static <T> T getCompleted(CompletionStage<T> stage) {
        CompletableFuture<T> future = stage.toCompletableFuture();
        CompletableFuturesExtra.checkCompleted(future);
        try {
            return future.join();
        }
        catch (CompletionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public static <T> CompletionStage<T> dereference(CompletionStage<? extends CompletionStage<T>> stage) {
        return stage.thenCompose(Identity.INSTANCE);
    }

    private static <T> CompletionStage<CompletionStage<T>> wrap(CompletionStage<T> future) {
        return future.thenApply(WrapFunction.INSTANCE);
    }

    private static enum WrapFunction implements Function
    {
        INSTANCE;


        public Object apply(Object o) {
            return CompletableFuture.completedFuture(o);
        }
    }

    private static enum Identity implements Function
    {
        INSTANCE;


        public Object apply(Object o) {
            return o;
        }
    }
}

