/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.futures;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public final class JoinedResults {
    private final Map<ListenableFuture<?>, Object> futures;

    private JoinedResults(Map<ListenableFuture<?>, Object> futures) {
        this.futures = futures;
    }

    public <T> T get(ListenableFuture<T> future) {
        Object value = this.futures.get(future);
        if (value == Null.INSTANCE) {
            return null;
        }
        if (value == null) {
            String message = "Attempt to access future value not part of joined operation";
            throw new IllegalArgumentException(message);
        }
        Object t = value;
        return (T)t;
    }

    private static enum Null {
        INSTANCE;

    }

    static class Transform
    implements Function<List<Object>, JoinedResults> {
        private final List<? extends ListenableFuture<?>> futures;

        public Transform(List<? extends ListenableFuture<?>> list) {
            this.futures = ImmutableList.copyOf(list);
        }

        public JoinedResults apply(List<Object> input) {
            String message = "Wrong number of futures resolved";
            Preconditions.checkArgument((input.size() == this.futures.size() ? 1 : 0) != 0, (Object)message);
            IdentityHashMap result = Maps.newIdentityHashMap();
            for (int i = 0; i < this.futures.size(); ++i) {
                Object value = input.get(i);
                if (value == null) {
                    value = Null.INSTANCE;
                }
                result.put(this.futures.get(i), value);
            }
            return new JoinedResults(result);
        }
    }
}

